/*!
  \file
  \brief ~l߃T[tFX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "FillSurface.h"
#include "EvaluateArea.h"
#include "SdlUtils.h"

using namespace beego;


struct FillSurface::pImpl {
  Surface surface;
  size_t width;
  size_t height;
  size_t x_offset;
  size_t y_offset;
  bool is_changed;

  pImpl(Surface obj, size_t surface_width, size_t surface_height,
	size_t surface_x_offset, size_t surface_y_offset)
    : surface(obj), width(surface_width), height(surface_height),
      x_offset(surface_x_offset), y_offset(surface_y_offset),
      is_changed(false) {
  }
};


FillSurface::FillSurface(Surface surface, size_t width, size_t height,
			 size_t x_offset, size_t y_offset)
  : pimpl(new pImpl(surface, width, height, x_offset, y_offset)) {
}


FillSurface::~FillSurface(void) {
}


void FillSurface::draw(std::vector<SDL_Rect>& update_rects,
		       const SDL_Rect* pos, const SDL_Rect* area,
		       size_t ticks) {

  size_t surface_width = pimpl->surface->getWidth();
  size_t surface_height = pimpl->surface->getHeight();
  //fprintf(stderr, "%d, %d\n", surface_width, surface_height);

  // !!! Ƃ肠AɎ܂\Ă݂
  // !!! offset ̒A܂

  // !!! ƂAarea  for ̏͌vZׂ
  std::vector<SDL_Rect> common_area;
  std::vector<SDL_Rect> unique_area;
  int y_offset = -(area->y % surface_height);
  int x_offset = -(area->x % surface_width);

  SDL_Rect eval_area;
  set_SdlRect(&eval_area, pos->x, pos->y, area->w, area->h);

  //fprintf(stderr, "x_offset: %d\n", x_offset);
  for (int h = y_offset;
       h < static_cast<int>(pimpl->height); h += surface_height) {
    for (int w = x_offset;
	 w < static_cast<int>(pimpl->width); w += surface_width) {
      SDL_Rect eval_pos;
      set_SdlRect(&eval_pos, pos->x + w, pos->y + h,
		  surface_width, surface_height);

      // !!! draw_area `Apčĕ`s
      // !!! for ŌJԂ͈͂ς̂Œӂ邱

      // !!! area ͂ݏoĂӏɂẮA`悵Ȃ悤ɂ
      // !!! ́A͂ݏoĂĂACɂ`悵Ă܂

      //fprintf(stderr, "eval_pos: %d, %d, %d, %d, eval_area: %d, %d, %d, %d\n", eval_pos.x, eval_pos.y, eval_pos.w, eval_pos.h, eval_area.x, eval_area.y, eval_area.w, eval_area.h);
      common_area.clear();

      //evaluateArea(common_area, unique_area, eval_pos, *area);
      evaluateArea(common_area, unique_area, eval_pos, eval_area);
      //fprintf(stderr, "common size: %d\n", common_area.size());
      //fprintf(stderr, "unique size: %d\n", unique_area.size());
      if (! common_area.empty()) {
	SDL_Rect& common = common_area.front();
	SDL_Rect draw_area;
	set_SdlRect(&draw_area, common.x - eval_pos.x, common.y - eval_pos.y,
		    common.w, common.h);
	//fprintf(stderr, "common: %d, %d, %d, %d\n", common.x, common.y, common.w, common.h);
	//fprintf(stderr, "draw_area: %d, %d, %d, %d\n", draw_area.x, draw_area.y, draw_area.w, draw_area.h);
	pimpl->surface->draw(update_rects, &common, &draw_area, ticks);
      }
      //fprintf(stderr, "\n");
    }
  }
}


size_t FillSurface::getWidth(void) {
  return pimpl->width;
}


size_t FillSurface::getHeight(void) {
  return pimpl->height;
}


bool FillSurface::isChanged(void) {
  bool ret = pimpl->is_changed;
  pimpl->is_changed = false;
  return ret;
}


bool FillSurface::isTransparent(void) {
  return pimpl->surface->isTransparent();
}
