#ifndef COMPONENT_INTERFACE_H
#define COMPONENT_INTERFACE_H

/*!
  \file
  \brief R|[lgC^[tF[X

  \author Satofumi KAMIMURA

  $Id$

  R|[lgƂ́A@\̎Ǘ (s...)
*/

#include "SurfaceList.h"

namespace beego {
  class InputEvent;

  /*!
    \brief R|[lgC^[tF[X
  */
  class ComponentInterface {
  public:
    virtual ~ComponentInterface() {}
    virtual void addSurfaceList(SurfaceList& surfaces,
				const SDL_Rect* area) = 0;
    virtual void setPosition(const SDL_Rect* position) = 0;

    // !!! SDL_Rect getPosition(void) ɕύX邩ȁH
    virtual void getPosition(SDL_Rect* position) = 0;

    virtual size_t getWidth(void) = 0;
    virtual size_t getHeight(void) = 0;
    virtual void applyInput(const InputEvent& event) = 0;
  };
};

#endif /* !COMPONENT_INTERFACE_H */
