/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo ĨXN[[hA[UɋL^ĊǗ
*/

#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "SystemDefinition.h"
#include "TypingRecorder.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "FillSurface.h"
#include "SdlSurface.h"
#include "TtfResource.h"
#include "InputReceiveComponent.h"
#include "LabelComponent.h"
#include "SearchFilePath.h"
#include "back_bmp.h"
#include "CreateSurfaceFromArray.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "ExistFile.h"
#include <string>

using namespace beego;


struct CommonResources::pImpl {
  SDL_Surface* scr;
  Surface back_bmp_surface;
  Surface back_surface;
  bool music_initialized;

  pImpl(void) :
    scr(SDL_GetVideoSurface()),
    back_bmp_surface(new SdlSurface(createSurface(back_bmp, back_bmp_width,
						  back_bmp_height))),
    back_surface(new FillSurface(back_bmp_surface, scr->w, scr->h)),
    music_initialized(false) {
  }
};


CommonResources::CommonResources(void)
  : pimpl(new pImpl),
    gui(new GuiManager), front_layer(new Layer), back_layer(new Layer),
    back_label(new LabelComponent(pimpl->back_surface)),
    font(new TtfResource(FontPath)), input(new InputHandler),
    input_receiver(new InputReceiveComponent),
    music(NULL), sound_effect(NULL),
    convert_type(TypingTextConverter::Roman), recorder(new TypingRecorder),
    practice_num(DefaultPracticeNum) {
  //practice_num(1) {		// !!! Ƃ肠AJ 0 or 1 ɂĂ

  gui->push_back(back_layer);
  gui->push_front(front_layer);
}


CommonResources::~CommonResources(void) {

  // !!! ܂AĂ΂邱Ƃ͑z肵ĂȂ񂾂...
  // !!! ̂AK؂ȃ\bhɈړ
  delete music;
  delete sound_effect;
  delete input;
  delete font;
  delete back_layer;
  delete front_layer;
  delete gui;
}


CommonResources* CommonResources::getObject(void) {
  static CommonResources obj;
  return &obj;
}


bool CommonResources::accessFontData(void) {

  std::string font_path;
  std::vector<std::string> dir_path;
  if (! searchFilePath(font_path, FontPath, dir_path)) {
    printf("\"%s\" is not found.\n", FontPath);
    return false;
  }
  return true;
}


bool CommonResources::accessMusicData(void) {

  if (existFile(Music1_FilePath) && existFile(Music2_FilePath)) {
    return true;
  } else {
    return false;
  }
}


void CommonResources::initializeMusic(void) {

  if (! pimpl->music_initialized) {

    // IuWFNg̐錾
    music = new MusicManager;
    if (! music->isInitialized()) {
      return;
    }
    sound_effect = new SoundEffectManager;

    // y̏
    music->registerMusic(BackMusic_1, Music1_FilePath);
    music->registerMusic(BackMusic_2, Music2_FilePath);
    // !!! ʉf[^̎wƂ

    pimpl->music_initialized = true;
  }
}


#if 0
bool CommonResources::isMusicInitialized(void) {
  return pimpl->music_initialized;
}
#endif


void CommonResources::terminate(void) {
  gui->stop();

  // !!! ȉOƁAZOgG[AǋýA...
  //delete font;
  //delete gui;
}

