#ifndef BUTTON_COMPONENT_H
#define BUTTON_COMPONENT_H

/*!
  \file
  \brief {^R|[lg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ComponentInterface.h"
#include <memory>

namespace beego {
  class TtfResource;

  class ButtonComponent : public ComponentInterface {
    ButtonComponent(const ButtonComponent& rhs);
    ButtonComponent& operator = (const ButtonComponent& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      NoSelect = -1,
    };
    ButtonComponent(void);
    ~ButtonComponent(void);

    void addSurfaceList(SurfaceList& surfaces, const SDL_Rect* area);
    void setPosition(const SDL_Rect* position);
    void getPosition(SDL_Rect* position);
    size_t getWidth(void);
    size_t getHeight(void);
    void applyInput(const InputEvent& event);

    // !!! 傫̈ႤT[tFXo^ꍇɂ́Aǂ̂ȁH
    // !!! - 傫͓ɂ
    // !!! - őTCYw肵ĂAT[tFXƈʒuwł悤ɂ
    // !!! - قȂT[tFXłAȂƌȂ
    // !!!   - T[tFX̊ʒuw肷
    // !!!     - SAAEA㉺AE

    // !!! `T[tFXTCYƁA̔zuItZbgwł΁AꂾH

    // T[tFXo^
    void registerNormalSurface(Surface surface,
			       int x_offset =0, int y_offset = 0);

    // T[tFXo^
    void registerPressedSurface(Surface surface,
				int x_offset =0, int y_offset = 0);

    // tH[JXT[tFXo^
    void registerFocusedSurface(Surface surface,
				int x_offset =0, int y_offset = 0);

    void showNormalSurface(void);
    void showPressedSurface(void);
    void showFocusedSurface(void);

    // !!! \T[tFXA[Uw肷邩AL[Ŏw肷邩AI

    bool isDecided(void);
    void releaseDecided(void);

    static void createSimpleButton(boost::shared_ptr<ButtonComponent>& button,
				   TtfResource* font, const Uint16* text,
				   size_t size, Uint32 fore, Uint32 back,
				   size_t selected_size,
				   Uint32 selected_fore,
				   Uint32 selected_back,
				   bool transparent = false);

    static void createSimpleButton(boost::shared_ptr<ButtonComponent>& button,
				   TtfResource* font, const char* text,
				   size_t size, Uint32 fore, Uint32 back,
				   size_t selected_size,
				   Uint32 selected_fore,
				   Uint32 selected_back,
				   bool transparent = false);
  };
};

#endif /* !BUTTON_COMPONENT_H */
