/*!
  \file
  \brief j[R|[lg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ButtonComponent.h"
#include "SwitchSurface.h"
#include "GridTypes.h"
#include "SdlUtils.h"
#include "Component.h"
#include "InputEvent.h"
#include "TextSurface.h"
#include "TtfResource.h"

using namespace beego;


struct ButtonComponent::pImpl {
  enum {
    NormalSurface = 0,
    PressedSurface,
    FocusedSurface,
    LastSurface,
  };
  boost::shared_ptr<SwitchSurface> surface;
  SDL_Rect position;
  bool position_changed;
  bool is_decided;
  DrawSurface draw_surface;

  pImpl(void)
    : surface(new SwitchSurface), position_changed(true), is_decided(false) {
    set_SdlRect(&position, 0, 0, 0, 0);
  }

  void updateComponentSize(void) {
    position.w = surface->getWidth();
    position.h = surface->getHeight();
  }
};


ButtonComponent::ButtonComponent(void) : pimpl(new pImpl) {
}


ButtonComponent::~ButtonComponent(void) {
}


void ButtonComponent::addSurfaceList(SurfaceList& surfaces,
				     const SDL_Rect* area) {
  updateDrawSurface(pimpl->draw_surface, pimpl->surface, area,
		    pimpl->position, pimpl->position_changed);
  surfaces.push_back(&pimpl->draw_surface);
  pimpl->position_changed = false;
}


void ButtonComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position, position->x, position->y);
  pimpl->updateComponentSize();
  pimpl->position_changed = true;
}


void ButtonComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position;
}


size_t ButtonComponent::getWidth(void) {
  return pimpl->surface->getWidth();
}


size_t ButtonComponent::getHeight(void) {
  return pimpl->surface->getHeight();
}


void ButtonComponent::registerNormalSurface(Surface surface,
					    int x_offset, int y_offset) {
  pimpl->surface->registerSurface(surface, x_offset, y_offset,
				  pImpl::NormalSurface);
  // ʏ{^́Ao^ꂽftHgŕ\悤ɐݒ肷
  showNormalSurface();
  pimpl->updateComponentSize();
}


void ButtonComponent::registerPressedSurface(Surface surface,
					     int x_offset, int y_offset) {
  pimpl->surface->registerSurface(surface, x_offset, y_offset,
				  pImpl::PressedSurface);

  // T[tFX傫o^̂߂ɁAꎞIɃT[tFX؂ւ
  size_t now_index = pimpl->surface->getIndex();
  pimpl->updateComponentSize();
  pimpl->surface->switchSurface(now_index);
}


void ButtonComponent::registerFocusedSurface(Surface surface,
					     int x_offset, int y_offset) {
  pimpl->surface->registerSurface(surface, x_offset, y_offset,
				  pImpl::FocusedSurface);

  // T[tFX傫o^̂߂ɁAꎞIɃT[tFX؂ւ
  size_t now_index = pimpl->surface->getIndex();
  pimpl->updateComponentSize();
  pimpl->surface->switchSurface(now_index);
}


void ButtonComponent::applyInput(const InputEvent& event) {

  if (pimpl->is_decided) {
    // ɉԂȂ΁AԂXVȂ
    return;
  }

  SDL_Rect surface_area;
  set_SdlRect(&surface_area, pimpl->position.x, pimpl->position.y,
	      getWidth(), getHeight());

  // }EXA\T[tFXɂꍇ̏
  bool changed = false;
  // !!! ۂɂ͕`悳ĂȂꍇ肤邪AƂ肠CɂȂ
  if (((event.mx >= surface_area.x) &&
       (event.mx <= surface_area.x + surface_area.w)) &&
      ((event.my >= surface_area.y) &&
       (event.my <= surface_area.y + surface_area.h))) {
    changed = true;

    if (event.left_released) {
      // 肳ꂽ
      showPressedSurface();
      pimpl->is_decided = true;

    } else {
      // tH[JX
      showFocusedSurface();
    }
  }
  if (! changed) {
    // dݒ̊Ǘ́ASwitchSurface ōsĂ
    showNormalSurface();
  }
}


void ButtonComponent::showNormalSurface(void) {
  pimpl->surface->switchSurface(pImpl::NormalSurface);
}


void ButtonComponent::showPressedSurface(void) {
  pimpl->surface->switchSurface(pImpl::PressedSurface);
}


void ButtonComponent::showFocusedSurface(void) {
  pimpl->surface->switchSurface(pImpl::FocusedSurface);
}


bool ButtonComponent::isDecided(void) {
  return pimpl->is_decided;
}


void ButtonComponent::releaseDecided(void) {
  pimpl->is_decided = false;
}


void ButtonComponent::createSimpleButton(boost::shared_ptr<ButtonComponent>&
					 button, TtfResource* font,
					 const Uint16* text, size_t size,
					 Uint32 fore, Uint32 back,
					 size_t selected_size,
					 Uint32 selected_fore,
					 Uint32 selected_back,
					 bool transparent) {
  // ʏT[tFX̍쐬
  Surface normal(new TextSurface(font, text, size, fore, back, transparent));
  button->registerNormalSurface(normal);

  // IT[tFX̍쐬
  Surface focused(new TextSurface(font, text, selected_size,
				  selected_fore, selected_back, transparent));
  button->registerFocusedSurface(focused);

  // 莞T[tFX̍쐬
  button->registerPressedSurface(focused);
}


void ButtonComponent::createSimpleButton(boost::shared_ptr<ButtonComponent>&
					 button, TtfResource* font,
					 const char* text, size_t size,
					 Uint32 fore, Uint32 back,
					 size_t selected_size,
					 Uint32 selected_fore,
					 Uint32 selected_back,
					 bool transparent) {
  // !!! ̏d́A...
  // !!! ȂƂ܂傤Bev[gɂłȂ񂾂...

  // ʏT[tFX̍쐬
  Surface normal(new TextSurface(font, text, size, fore, back, transparent));
  button->registerNormalSurface(normal);

  // IT[tFX̍쐬
  Surface focused(new TextSurface(font, text, selected_size,
				  selected_fore, selected_back, transparent));
  button->registerFocusedSurface(focused);

  // 莞T[tFX̍쐬
  button->registerPressedSurface(focused);
}
