// 2003/03/18 SvAgreementPage.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using NTF.HXD.DOC;

namespace NTF.HXD.GUI.TabPage
{
	/// <summary>
	/// AO[gݒŎgpRg[
	/// </summary>
	public class SvAgreementPage : System.Windows.Forms.UserControl , IConfigTabPage
	{

		#region Rg[

		private System.Windows.Forms.TextBox agreementBox;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ToolBar toolBar;
		private System.Windows.Forms.ToolBarButton tbReload;
		private System.Windows.Forms.ImageList imageList;

		#endregion 

		Appli appli;

		public SvAgreementPage(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			LoadConfig();
			this.Dock = DockStyle.Fill;
		}


		/// <summary>
		/// ݒǂݍŔf܂B
		/// </summary>
		public void LoadConfig()
		{
			LinuxFile lFile = new LinuxFile();
			System.Text.StringBuilder b = lFile.Load( appli.ServerConfig.PathsConfig.Agreement );

			if( b != null )
			{
				this.agreementBox.Text = b.ToString();
			}
		}


		/// <summary>
		/// ݒvpeBɊi[܂B
		/// </summary>
		public void SaveConfig()
		{
			try
			{
				if( this.agreementBox.Text.Equals( string.Empty ) )
				{
					System.IO.File.Delete( appli.ServerConfig.PathsConfig.Agreement );
				}
				else
				{
					LinuxFile lFile = new LinuxFile();

					lFile.Write( appli.ServerConfig.PathsConfig.Agreement ,
						this.agreementBox.Text );
				}
			}
			catch
			{
				MessageBox.Show ( "AO[g̕ۑɎs܂B" , "G[",
					MessageBoxButtons.OK, MessageBoxIcon.Error);

			}
		}



		/// <summary>
		/// ݒ肪ύXAݒ𔽉fɂ͍ċNKvȂƂtrueԂB
		/// </summary>
		public bool Changed
		{
			get{return false;}
			set{}
		}


		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SvAgreementPage));
			this.agreementBox = new System.Windows.Forms.TextBox();
			this.toolBar = new System.Windows.Forms.ToolBar();
			this.tbReload = new System.Windows.Forms.ToolBarButton();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.SuspendLayout();
			// 
			// agreementBox
			// 
			this.agreementBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.agreementBox.Location = new System.Drawing.Point(0, 25);
			this.agreementBox.Multiline = true;
			this.agreementBox.Name = "agreementBox";
			this.agreementBox.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.agreementBox.Size = new System.Drawing.Size(584, 233);
			this.agreementBox.TabIndex = 0;
			this.agreementBox.Text = "";
			// 
			// toolBar
			// 
			this.toolBar.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																																							 this.tbReload});
			this.toolBar.DropDownArrows = true;
			this.toolBar.ImageList = this.imageList;
			this.toolBar.Name = "toolBar";
			this.toolBar.ShowToolTips = true;
			this.toolBar.Size = new System.Drawing.Size(584, 25);
			this.toolBar.TabIndex = 1;
			this.toolBar.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar_ButtonClick);
			// 
			// tbReload
			// 
			this.tbReload.ImageIndex = 0;
			this.tbReload.Text = "ēǂݍ";
			// 
			// imageList
			// 
			this.imageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit;
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// SvAgreementPage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.agreementBox,
																																	this.toolBar});
			this.Name = "SvAgreementPage";
			this.Size = new System.Drawing.Size(584, 258);
			this.ResumeLayout(false);

		}
		#endregion

		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			this.LoadConfig();
		}


	}
}
