// 2003/03/20 MainForm.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;

using NTF.HXD.GUI.TabPage;
using NTF.DOC;
using NTF.HXD.DOC;

namespace NTF.HXD.GUI
{
	public class MainForm : NTF.GUI.TaskTrayForm
	{


		#region Rg[

		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.TabControl tbServer;
		private System.Windows.Forms.TabControl tbTop;
		private System.Windows.Forms.TabPage tpSvGeneral;
		private System.Windows.Forms.TabPage tpSvBan;
		private System.Windows.Forms.TabPage tpSvTracker;
		private System.Windows.Forms.TabPage tpSvAgree;
		private System.Windows.Forms.TabPage tpSvFlatNews;
		private System.Windows.Forms.Button btnStartServer;
		private System.Windows.Forms.Button btnStopServer;
		private System.Windows.Forms.Button btnTaskTray;
		private System.Windows.Forms.Button btnQuite;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.TabPage tpServerOption;
		private System.Windows.Forms.TabPage tpServerLog;
		private System.Windows.Forms.TabPage tpSvFile;
		private System.Windows.Forms.TabPage tpOperation;
		private System.Windows.Forms.TabPage tpAppOption;
		private System.Windows.Forms.ContextMenu contextMenu;
		private System.Windows.Forms.MenuItem cShowMenu;
		private System.Windows.Forms.MenuItem cQuiteMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem cStartServerMenu;
		private System.Windows.Forms.MenuItem cStopServerMenu;

		#endregion


		Appli appli;
		Icon dcIcon;
		Icon cIcon;
		private System.Windows.Forms.MenuItem cOpenFileFolder;
		private System.Windows.Forms.MenuItem menuItem3;


		ArrayList pageList = new ArrayList();

		public MainForm(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			this.appli.HXDBootManager.Stoped += new EventHandler(HXD_Exited);

			InitializeControl();

			Application.Idle += new EventHandler( App_Idle );

			this.cIcon = ((System.Drawing.Icon)((new System.Resources.ResourceManager(typeof(MainForm))).GetObject("connectedIcon")));
			this.dcIcon = this.notifyIcon.Icon;
		}


		#region Rg[\z
		private void InitializeControl()
		{
			this.tpSvGeneral.Controls.Add( 
				AddConfigPage(new SvGeneralPage( appli ))
				);

			this.tpSvFile.Controls.Add( 
				AddConfigPage(new SvFilePage( appli ))
				);

			this.tpSvBan.Controls.Add( 
				AddConfigPage(new SvBANPage( appli ))
				);

			this.tpSvTracker.Controls.Add( 
				AddConfigPage(new SvTrackerPage( appli ))
				);

			this.tpSvAgree.Controls.Add( 
				AddConfigPage(new SvAgreementPage( appli ))
				);

			this.tpSvFlatNews.Controls.Add( 
				AddConfigPage(new SvFlatNews( appli ))
				);

			this.tpServerLog.Controls.Add( 
				AddConfigPage(new LogPage( appli ))
				);

			this.tpAppOption.Controls.Add( 
				AddConfigPage(new AppOptionPage( appli ))
				);

			this.notifyIcon.ContextMenu = this.contextMenu;
			this.Text = appli.ServerConfig.TrackerConfig.Name + " - hxdHelper";
			this.notifyIcon.Text = appli.ServerConfig.TrackerConfig.Name;
		}


		private UserControl AddConfigPage(IConfigTabPage configPage)
		{
			this.pageList.Add( configPage );
			return (UserControl)configPage;
		}
		#endregion


		#region {^nh

		private void btnStartServer_Click(object sender, System.EventArgs e)
		{
			if( !this.btnStartServer.Enabled )
			{
				return;
			}

			try
			{
				appli.HXDBootManager.Start();
			}
			catch
			{
				MessageBox.Show ( "T[o[Jnł܂B" , "G[",
					MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			changeServerState();
		}

		private void btnStopServer_Click(object sender, System.EventArgs e)
		{
			if( !this.btnStopServer.Enabled )
			{
				return;
			}

			try
			{
				appli.HXDBootManager.Stop();
			}
			catch
			{
				MessageBox.Show ( "T[o[̒~Ɏs܂B" , "G[",
					MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
		}


		private void btnTaskTray_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnQuite_Click(object sender, System.EventArgs e)
		{	
			if( !this.btnStartServer.Enabled )
			{
				DialogResult result;

				result = MessageBox.Show ( "T[o[ғłBIĂ낵łH" , "mF",
					MessageBoxButtons.OKCancel, MessageBoxIcon.Question);

				if( result == DialogResult.Cancel )
				{
					return;
				}
			}
			this.sessionEnding = true;
			this.Close();
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			bool changed = false;
			for(int i = 0 ; i < this.pageList.Count ; i++ )
			{
				IConfigTabPage page = (IConfigTabPage)pageList[i];
				page.SaveConfig();

				if( page.Changed )
				{
					changed = true;
				}

				page.Changed = false;

			}

			appli.Setting.Save();

			if( changed && !this.btnStartServer.Enabled)
			{
				MessageBox.Show ( "ݒ𔽉fɂ̓T[o[̍ċNKvłB" , "",
					MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
			}

			this.Text = appli.ServerConfig.TrackerConfig.Name + " - hxdHelper";
		}

		#endregion


		#region tH[nh

		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad(e);

			this.Bounds = WindowPositionSetting.Load( this.Name );

			if( appli.AppConfig.AutoStart )
			{
				this.btnStartServer_Click( this , e );
			}
		}

		protected override void OnClosed(EventArgs e)
		{
			WindowPositionSetting.Save( this , this.Name );
			this.btnStopServer_Click( this , e );
			base.OnClosed(e);
		}

		#endregion


		#region ReLXgj[ nh

		private void contextMenu_Popup(object sender, System.EventArgs e)
		{
			if( this.Visible )
			{
				this.cShowMenu.Text = "gCɊi[(&Y)";
			}
			else
			{
				this.cShowMenu.Text = "(&R)";
			}
		}

		private void cShowMenu_Click(object sender, System.EventArgs e)
		{
			if( this.Visible )
			{
				this.WindowState = FormWindowState.Normal;
				this.btnTaskTray_Click( sender , e );
			}
			else
			{
				this.notifyIcon_DoubleClick( sender , e );
			}
		}

		private void cQuiteMenu_Click(object sender, System.EventArgs e)
		{
			this.btnQuite_Click( sender , e );
		}

		private void cStartServerMenu_Click(object sender, System.EventArgs e)
		{
			this.btnStartServer_Click( sender , e );
		}

		private void cStopServerMenu_Click(object sender, System.EventArgs e)
		{
			this.btnStopServer_Click( sender , e );
		}

		#endregion


		private void HXD_Exited(object sender , EventArgs e)
		{
			changeServerState();
		}


		/// <summary>
		/// NɃgCɓݒ̂Ƃ񂾂B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void App_Idle(object sender , EventArgs e)
		{
			if( appli.AppConfig.AutoTray )
			{
				this.btnTaskTray_Click( this , e );
			}

			Application.Idle -= new EventHandler( App_Idle );
		}


		private void changeServerState()
		{
			this.btnStartServer.Enabled = !this.btnStartServer.Enabled;
			this.btnStopServer.Enabled  = !this.btnStopServer.Enabled;
			this.cStartServerMenu.Enabled = !this.cStartServerMenu.Enabled;
			this.cStopServerMenu.Enabled  = !this.cStopServerMenu.Enabled;
			if( this.btnStartServer.Enabled )
			{
				this.Icon = this.notifyIcon.Icon = this.dcIcon;
			}
			else
			{
				this.Icon = this.notifyIcon.Icon = this.cIcon;
			}
		}

		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Designer generated code
		/// <summary>
		/// Designer T|[gɕKvȃ\bhłBR[h GfB^
		/// ̃\bh̃RecύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.tbTop = new System.Windows.Forms.TabControl();
			this.tpServerOption = new System.Windows.Forms.TabPage();
			this.tbServer = new System.Windows.Forms.TabControl();
			this.tpSvGeneral = new System.Windows.Forms.TabPage();
			this.tpSvFile = new System.Windows.Forms.TabPage();
			this.tpSvBan = new System.Windows.Forms.TabPage();
			this.tpSvTracker = new System.Windows.Forms.TabPage();
			this.tpSvAgree = new System.Windows.Forms.TabPage();
			this.tpSvFlatNews = new System.Windows.Forms.TabPage();
			this.tpServerLog = new System.Windows.Forms.TabPage();
			this.tpAppOption = new System.Windows.Forms.TabPage();
			this.btnStartServer = new System.Windows.Forms.Button();
			this.btnStopServer = new System.Windows.Forms.Button();
			this.btnTaskTray = new System.Windows.Forms.Button();
			this.btnQuite = new System.Windows.Forms.Button();
			this.btnSave = new System.Windows.Forms.Button();
			this.tpOperation = new System.Windows.Forms.TabPage();
			this.contextMenu = new System.Windows.Forms.ContextMenu();
			this.cStartServerMenu = new System.Windows.Forms.MenuItem();
			this.cStopServerMenu = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.cShowMenu = new System.Windows.Forms.MenuItem();
			this.cQuiteMenu = new System.Windows.Forms.MenuItem();
			this.cOpenFileFolder = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.tbTop.SuspendLayout();
			this.tpServerOption.SuspendLayout();
			this.tbServer.SuspendLayout();
			this.SuspendLayout();
			// 
			// notifyIcon
			// 
			this.notifyIcon.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon.Icon")));
			this.notifyIcon.Text = "HXD for Win";
			// 
			// tbTop
			// 
			this.tbTop.Controls.AddRange(new System.Windows.Forms.Control[] {
																																				this.tpServerOption,
																																				this.tpServerLog,
																																				this.tpAppOption});
			this.tbTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.tbTop.Name = "tbTop";
			this.tbTop.SelectedIndex = 0;
			this.tbTop.Size = new System.Drawing.Size(602, 302);
			this.tbTop.TabIndex = 0;
			// 
			// tpServerOption
			// 
			this.tpServerOption.Controls.AddRange(new System.Windows.Forms.Control[] {
																																								 this.tbServer});
			this.tpServerOption.Location = new System.Drawing.Point(4, 21);
			this.tpServerOption.Name = "tpServerOption";
			this.tpServerOption.Size = new System.Drawing.Size(594, 277);
			this.tpServerOption.TabIndex = 1;
			this.tpServerOption.Text = "T[o[ݒ";
			// 
			// tbServer
			// 
			this.tbServer.Controls.AddRange(new System.Windows.Forms.Control[] {
																																					 this.tpSvGeneral,
																																					 this.tpSvFile,
																																					 this.tpSvBan,
																																					 this.tpSvTracker,
																																					 this.tpSvAgree,
																																					 this.tpSvFlatNews});
			this.tbServer.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tbServer.Name = "tbServer";
			this.tbServer.SelectedIndex = 0;
			this.tbServer.Size = new System.Drawing.Size(594, 277);
			this.tbServer.TabIndex = 0;
			// 
			// tpSvGeneral
			// 
			this.tpSvGeneral.Location = new System.Drawing.Point(4, 21);
			this.tpSvGeneral.Name = "tpSvGeneral";
			this.tpSvGeneral.Size = new System.Drawing.Size(586, 252);
			this.tpSvGeneral.TabIndex = 0;
			this.tpSvGeneral.Text = "S";
			// 
			// tpSvFile
			// 
			this.tpSvFile.Location = new System.Drawing.Point(4, 21);
			this.tpSvFile.Name = "tpSvFile";
			this.tpSvFile.Size = new System.Drawing.Size(586, 252);
			this.tpSvFile.TabIndex = 1;
			this.tpSvFile.Text = "t@C";
			// 
			// tpSvBan
			// 
			this.tpSvBan.Location = new System.Drawing.Point(4, 21);
			this.tpSvBan.Name = "tpSvBan";
			this.tpSvBan.Size = new System.Drawing.Size(586, 252);
			this.tpSvBan.TabIndex = 2;
			this.tpSvBan.Text = "ؒf";
			// 
			// tpSvTracker
			// 
			this.tpSvTracker.Location = new System.Drawing.Point(4, 21);
			this.tpSvTracker.Name = "tpSvTracker";
			this.tpSvTracker.Size = new System.Drawing.Size(586, 252);
			this.tpSvTracker.TabIndex = 3;
			this.tpSvTracker.Text = "gbJ[";
			// 
			// tpSvAgree
			// 
			this.tpSvAgree.Location = new System.Drawing.Point(4, 21);
			this.tpSvAgree.Name = "tpSvAgree";
			this.tpSvAgree.Size = new System.Drawing.Size(586, 252);
			this.tpSvAgree.TabIndex = 4;
			this.tpSvAgree.Text = "AO[g";
			// 
			// tpSvFlatNews
			// 
			this.tpSvFlatNews.Location = new System.Drawing.Point(4, 21);
			this.tpSvFlatNews.Name = "tpSvFlatNews";
			this.tpSvFlatNews.Size = new System.Drawing.Size(586, 252);
			this.tpSvFlatNews.TabIndex = 5;
			this.tpSvFlatNews.Text = "tbgj[X";
			// 
			// tpServerLog
			// 
			this.tpServerLog.Location = new System.Drawing.Point(4, 21);
			this.tpServerLog.Name = "tpServerLog";
			this.tpServerLog.Size = new System.Drawing.Size(594, 277);
			this.tpServerLog.TabIndex = 2;
			this.tpServerLog.Text = "O";
			// 
			// tpAppOption
			// 
			this.tpAppOption.Location = new System.Drawing.Point(4, 21);
			this.tpAppOption.Name = "tpAppOption";
			this.tpAppOption.Size = new System.Drawing.Size(594, 277);
			this.tpAppOption.TabIndex = 3;
			this.tpAppOption.Text = "AvP[Vݒ";
			// 
			// btnStartServer
			// 
			this.btnStartServer.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnStartServer.Location = new System.Drawing.Point(3, 311);
			this.btnStartServer.Name = "btnStartServer";
			this.btnStartServer.TabIndex = 1;
			this.btnStartServer.Text = "T[o[Jn";
			this.btnStartServer.Click += new System.EventHandler(this.btnStartServer_Click);
			// 
			// btnStopServer
			// 
			this.btnStopServer.Enabled = false;
			this.btnStopServer.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnStopServer.Location = new System.Drawing.Point(85, 311);
			this.btnStopServer.Name = "btnStopServer";
			this.btnStopServer.TabIndex = 2;
			this.btnStopServer.Text = "T[o[~";
			this.btnStopServer.Click += new System.EventHandler(this.btnStopServer_Click);
			// 
			// btnTaskTray
			// 
			this.btnTaskTray.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnTaskTray.Location = new System.Drawing.Point(441, 311);
			this.btnTaskTray.Name = "btnTaskTray";
			this.btnTaskTray.TabIndex = 3;
			this.btnTaskTray.Text = "gCɊi[";
			this.btnTaskTray.Click += new System.EventHandler(this.btnTaskTray_Click);
			// 
			// btnQuite
			// 
			this.btnQuite.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnQuite.Location = new System.Drawing.Point(524, 311);
			this.btnQuite.Name = "btnQuite";
			this.btnQuite.TabIndex = 4;
			this.btnQuite.Text = "I";
			this.btnQuite.Click += new System.EventHandler(this.btnQuite_Click);
			// 
			// btnSave
			// 
			this.btnSave.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnSave.Location = new System.Drawing.Point(358, 311);
			this.btnSave.Name = "btnSave";
			this.btnSave.TabIndex = 5;
			this.btnSave.Text = "ݒۑ";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// tpOperation
			// 
			this.tpOperation.Location = new System.Drawing.Point(4, 21);
			this.tpOperation.Name = "tpOperation";
			this.tpOperation.Size = new System.Drawing.Size(586, 252);
			this.tpOperation.TabIndex = 0;
			// 
			// contextMenu
			// 
			this.contextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																								this.cOpenFileFolder,
																																								this.menuItem3,
																																								this.cStartServerMenu,
																																								this.cStopServerMenu,
																																								this.menuItem1,
																																								this.cShowMenu,
																																								this.cQuiteMenu});
			this.contextMenu.Popup += new System.EventHandler(this.contextMenu_Popup);
			// 
			// cStartServerMenu
			// 
			this.cStartServerMenu.Index = 2;
			this.cStartServerMenu.Text = "T[o[Jn(&S)";
			this.cStartServerMenu.Click += new System.EventHandler(this.cStartServerMenu_Click);
			// 
			// cStopServerMenu
			// 
			this.cStopServerMenu.Enabled = false;
			this.cStopServerMenu.Index = 3;
			this.cStopServerMenu.Text = "T[o[~(&Q)";
			this.cStopServerMenu.Click += new System.EventHandler(this.cStopServerMenu_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 4;
			this.menuItem1.Text = "-";
			// 
			// cShowMenu
			// 
			this.cShowMenu.Index = 5;
			this.cShowMenu.Text = "(&R)";
			this.cShowMenu.Click += new System.EventHandler(this.cShowMenu_Click);
			// 
			// cQuiteMenu
			// 
			this.cQuiteMenu.Index = 6;
			this.cQuiteMenu.Text = "I(&X)";
			this.cQuiteMenu.Click += new System.EventHandler(this.cQuiteMenu_Click);
			// 
			// cOpenFileFolder
			// 
			this.cOpenFileFolder.Index = 0;
			this.cOpenFileFolder.Text = "t@CtH_J(&O)";
			this.cOpenFileFolder.Click += new System.EventHandler(this.cOpenFileFolder_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.Text = "-";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(602, 339);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.btnSave,
																																	this.btnQuite,
																																	this.btnTaskTray,
																																	this.btnStopServer,
																																	this.btnStartServer,
																																	this.tbTop});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(608, 364);
			this.Name = "MainForm";
			this.Text = "HXD for Win";
			this.tbTop.ResumeLayout(false);
			this.tpServerOption.ResumeLayout(false);
			this.tbServer.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void cOpenFileFolder_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start( this.appli.ServerConfig.PathsConfig.Files.Replace("/" ,"\\"));
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}
		}
		

	}
}

