// 2003/03/18 ConfigWriter.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Text;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// ݒރwp[
	/// </summary>
	public class ConfigWriter
	{
		StringBuilder sBuilder;
		public ConfigWriter(StringBuilder sBuilder)
		{
			this.sBuilder = sBuilder;
		}

		/// <summary>
		/// ݒ̃JeS[݂܂
		/// </summary>
		/// <param name="name">JeS[</param>
		public void StartCategory(string name)
		{
			sBuilder.Append( name + " {" + "\r\n");
		}

		/// <summary>
		/// s݂܂B
		/// </summary>
		/// <param name="s">ޓe</param>
		public void WriteLine(string s)
		{
			sBuilder.Append( s + "\r\n" );
		}

		/// <summary>
		/// s݂܂B
		/// </summary>
		public void WriteLine()
		{
			this.WriteLine("");
		}

		/// <summary>
		/// ݒށB
		/// </summary>
		/// <param name="name">ݒ薼</param>
		/// <param name="pValue">ݒ̒l</param>
		public void WriteProperty(string name ,string pValue)
		{
			if( pValue.Equals( string.Empty ))
			{
				return;
			}
			 sBuilder.Append("	" + name + " " + pValue + ";" + "\r\n");
		}

		/// <summary>
		/// Rg݂܂B
		/// </summary>
		/// <param name="comment">Rg</param>
		public void WriteComment( string comment )
		{
			sBuilder.Append("	# " + comment + "\r\n");
		}

		/// <summary>
		/// pň͂܂ݒ̒l݂܂B
		/// </summary>
		/// <param name="name">ݒ薼</param>
		/// <param name="pValue">ݒ̒l</param>
		public void WriteQuoteProperty( string name , string pValue)
		{
			sBuilder.Append("	"  + name + " " + CreateQuote(pValue) + ";" + "\r\n" );
		}


		/// <summary>
		/// pŕ͂
		/// </summary>
		/// <param name="s"></param>
		/// <returns>̕</returns>
		public string CreateQuote(string s)
		{
			return "\"" + s + "\"";
		}

		/// <summary>
		/// ݒ̃JeS[̏I݂܂B
		/// </summary>
		public void EndCategory()
		{
			sBuilder.Append( "};" + "\r\n" + "\r\n");
		}


	}
}
