// 2003/03/20 BootManager.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace NTF.HXD
{
	/// <summary>
	/// HXD̋NAIǗB
	/// </summary>
	public class BootManager
	{
		Appli appli;

		Process hxdProcess = new Process();

		public BootManager(Appli appli)
		{
			this.appli = appli;
		}

		bool started = false;

		public event EventHandler Stoped;

		/// <summary>
		/// HXDNB
		/// </summary>
		public void Start()
		{
			try
			{
				//ImFB
				//int code = hxdProcess.ExitCode;
				if( started )
				{
					return;
				}

				hxdProcess.Exited -= new EventHandler(HXD_Exited);
				hxdProcess.Close();

				ProcessStartInfo startInfo = new ProcessStartInfo( appli.AppConfig.HXDPath );
				startInfo.WindowStyle = ProcessWindowStyle.Hidden;
				//hxdProcess = Process.Start( appli.AppConfig.HXDPath );
				hxdProcess = Process.Start( startInfo );

				hxdProcess.EnableRaisingEvents = true;
				hxdProcess.Exited += new EventHandler(HXD_Exited);

				started = true;
			}
			catch(System.Exception error)
			{
				throw error;
			}
		}

		/// <summary>
		/// HXDIB
		/// </summary>
		public void Stop()
		{
			try
			{
				hxdProcess.Kill();
				if( !appli.AppConfig.EnableMultipleBoot )
				{
					Process[] process = Process.GetProcessesByName ("hxd");     									 

					for(int i = 0 ; i < process.Length  ; i++ )
					{
						try
						{
							process[i].Kill();
						}
						catch(System.Exception error)
						{
							System.Diagnostics.Debug.WriteLine(error);
						}
					}
				}
			}
			catch(System.Exception error)
			{
				throw error;
			}
		}

		/// <summary>
		/// HXDIɔCxg𔭍sB
		/// </summary>
		/// <param name="sender">s</param>
		/// <param name="e">EventArgs</param>
		private void HXD_Exited(object sender , EventArgs e)
		{
			started = false;

			if( Stoped == null )
			{
				return;
			}

			foreach(EventHandler stoped in Stoped.GetInvocationList())
			{
				try
				{
					stoped(sender , e);
				}
				catch(System.Exception error)
				{
					System.Diagnostics.Debug.WriteLine(error);
				}
			}
		}
	}
}
