// 2003/03/18 Context.cs 
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//TODO : dlɉp[TB(LoadToken)
using System;
using System.Collections;
using NTF.HXD.DOC;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// ݒt@Cg[Nɋ؂B
	/// </summary>
	public class Context
	{

		/// <summary>
		/// ݒt@Cg[NɕĊi[B
		/// </summary>
		ArrayList token = new ArrayList();

		/// <summary>
		/// ݂̃g[ÑCfbNX
		/// </summary>
		int currentIndex = -1;

		Regex rDivider	= new Regex(@"\s");
		Regex rQuote		= new Regex("\"");
		Regex rWord			= new Regex("(\".*\"*\")");
		Regex rComment	= new Regex("#");


		/// <summary>
		/// RXgN^Bt@Cݒǂݍ݃g[Nɋ؂܂B
		/// </summary>
		public Context(string path)
		{
			LoadToken(path);
		}


		/// <summary>
		/// Õg[N
		/// </summary>
		/// <returns>g[N 擪z鎞ɂnull</returns>
		public string PreviousToken()
		{
			currentIndex--;

			if( currentIndex < 0 )
			{
				return null;
			}

			return (string)token[currentIndex];
		}


		/// <summary>
		/// ̃g[NԂ܂B
		/// </summary>
		/// <returns>g[N g[N̏Iɂnull</returns>
		public string NextToken()
		{
			currentIndex++;
			if( currentIndex > token.Count - 1 )
			{
				return null;
			}

			return (string)token[currentIndex];
		}


		/// <summary>
		/// ݂̃g[NԂ܂B
		/// </summary>
		/// <returns>g[N</returns>
		public string CurrentToken()
		{
			if( currentIndex > token.Count - 1 )
			{
				return null;
			}

			return (string)token[currentIndex];
		}


		/// <summary>
		/// ݂̃g[N`FbNÃg[Nǂݍ݂܂B
		/// </summary>
		/// <returns>
		/// false̎͊Ƀg[N̏Ił邱Ƃ܂B
		/// </returns>
		public bool SkipToken()
		{
			if( CurrentToken() == null )
			{
				return false;
			}
			else
			{
				NextToken();
				return true;
			}
		}


		#region ݒg[Nɋ؂B
		/// <summary>
		/// ݒg[Nɋ؂
		/// </summary>
		/// <param name="path">ݒt@C̃pX</param>
		/// <remarks>
		/// <para>p[T͂܂Ƃɍ肱ނƖʓ|Ȃ̂ŁAȉ̂悤ȐݒOƂB</para>
		/// <para>1 )p("")ɂ;̃g[N؂͂Ȃ̂ƂB</para>
		/// <para>2 )pɈp݂͑Ȃ̂ƂB</para>
		/// <para>3	)[U[ҏWRg͍폜B</para>
		/// <para>4 )ݒ荀ڂɂ͕Klݒ肳ĂB</para>
		/// </remarks>
		private void  LoadToken(string path)
		{

			LinuxFile file = new LinuxFile();
			StringBuilder bString = file.Load( path ,
																				 Encoding.GetEncoding(932) );

			if( bString == null )
			{
				return;
			}

			bString = RemoveComment( bString.ToString() );
			bString = bString.Replace("\r\n" , string.Empty );

			string[] tempToken = bString.ToString().Split(';');

			string[] temp = null;

			for( int i = 0 ; i < tempToken.Length ; i++ )
			{
				//(""݂͂̕)
				if( rQuote.IsMatch( tempToken[i] ) )
				{
					Match m = rWord.Match( tempToken[i] );
					string[] preTemp = rDivider.Split( tempToken[i].Substring( 0 , m.Index ));
				
					temp = new string[ preTemp.Length + 1];
					for( int pCount = 0 ; pCount < temp.Length ; pCount++ )
					{
						if( pCount == temp.Length - 1 )
						{
							temp[pCount] = m.Value;
						}
						else
						{
							temp[pCount] = preTemp[pCount];
						}
					}
				}
				else
				{
					temp = rDivider.Split( tempToken[i] );
				}

				if( temp == null )
				{
					break;
				}

				for( int j = 0 ; j < temp.Length ; j++ )
				{
					if( !temp[j].Equals( string.Empty ) )
					{
						token.Add( temp[j] );
					}
				}
			}
		}


		/// <summary>
		/// ݒ̃RgB
		/// </summary>
		/// <param name="content">ݒe</param>
		/// <returns>Rg̕</returns>
		private StringBuilder RemoveComment( string content )
		{
			if( content == null || content == string.Empty )
			{
				return null;
			}

			StringReader reader = new StringReader( content );
			string tempLine = string.Empty;
			StringBuilder bString = new StringBuilder();

			while(true)
			{
				tempLine = reader.ReadLine();

				if( tempLine == null )
				{
					break;
				}
				if( !rComment.IsMatch(tempLine) )
				{
					bString.Append( tempLine + "\r\n" );
				}
			}

			return bString;
		}
		#endregion


	}
}
