#
# PCMCIA Card Configuration Database
#
# config 1.167 2001/05/10 03:17:35 (David Hinds)
#

# config.opts is now included at the very end

#
# Device driver definitions
#
device "3c589_cs"
  class "network" module "3c589_cs"

device "ibmtr_cs"
  class "network" module "ibmtr_cs"

device "nmclan_cs"
  class "network" module "nmclan_cs"

device "oti12_cs"
  class "cdrom" module "oti12_cs"

device "pcnet_cs"
  class "network" module "net/8390", "pcnet_cs"

device "smc91c92_cs"
  class "network" module "smc91c92_cs"

device "wavelan_cs"
  class "network" module "wavelan_cs"

device "wvlan_cs"
  class "network" module "wvlan_cs"

device "memory_cs" needs_mtd
  class "memory" module "memory_cs"

device "ftl_cs" needs_mtd
  class "ftl" module "ftl_cs"

device "serial_cs"
  class "serial" module "serial_cs"

device "parport_cs"
  class "parport" module "parport_cs"

device "qlogic_cs"
  class "scsi" module "qlogic_cs"

device "aha152x_cs"
  class "scsi" module "aha152x_cs"

device "fdomain_cs"
  class "scsi" module "fdomain_cs"

device "sym53c500_cs"
  class "scsi" module "sym53c500_cs"

device "ide_cs"
  class "ide" module "ide_cs"

device "fmvj18x_cs"
  class "network" module "fmvj18x_cs" 

device "netwave_cs"
  class "network" module "netwave_cs"

device "xirc2ps_cs"
  class "network" module "xirc2ps_cs"

device "iscc_cs"
  class "iscc" module "iscc_cs"

device "3c574_cs"
  class "network" module "3c574_cs"

device "teles_cs"
  class "teles" module "teles_cs"

device "3c575_cb"
  class "network" module "cb_enabler", "3c575_cb"

device "apa1480_cb"
  class "scsi" module "cb_enabler", "apa1480_cb"

device "tulip_cb"
  class "network" module "cb_enabler", "tulip_cb"

device "memory_cb"
  class "memory" module "cb_enabler", "memory_cb"

device "epic_cb"
  class "network" module "cb_enabler", "epic_cb"

device "eepro100_cb"
  class "network" module "cb_enabler", "eepro100_cb"

device "serial_cb"
  class "serial" module "cb_enabler", "serial_cb"

device "ray_cs"
  class "network" module "ray_cs"

device "airo_cs"
  class "network" module "airo", "airo_cs"

device "pcilynx_cb"
  class "ieee1394" module "cb_enabler", "pcilynx_cb"
  
device "ohci1394_cb"
  class "ieee1394" module "cb_enabler", "ohci1394_cb"

#
# Ethernet adapter definitions
#
card "2412LAN Ethernet"
  version "2412LAN"
  bind "pcnet_cs"

card "3Com 589 Ethernet"
  manfid 0x0101, 0x0589
  bind "3c589_cs"

card "Access/CARD Ethernet"
  version "UBKK,V2.0"
  bind "fmvj18x_cs"

card "Accton EN2212 Ethernet"
  version "ACCTON", "EN2212"
  bind "pcnet_cs"

card "Accton EN2216 Ethernet"
  version "ACCTON", "EN2216-PCMCIA-ETHERNET"
  bind "pcnet_cs"

card "Accton UE2212 Ethernet"
  version "PCMCIA", "UE2212"
  bind "pcnet_cs"

card "Accton UE2216 Ethernet"
  version "PCMCIA", "PCMCIA-ETHERNET-CARD", "UE2216"
  bind "pcnet_cs"

card "Allied Telesis LA-PCM Ethernet"
  manfid 0xc00f, 0x0002
  cis "cis/LA-PCM.dat"
  bind "pcnet_cs"

card "AmbiCom AMB8002 Ethernet"
  version "AmbiCom Inc", "AMB8002"
  bind "pcnet_cs"

card "AmbiCom AMB8002T Ethernet"
  version "AmbiCom Inc", "AMB8002T"
  bind "pcnet_cs"

card "AmbiCom AMB8010 Ethernet"
  version "AmbiCom Inc", "AMB8010"
  bind "pcnet_cs"

card "AnyCom ECO Ethernet"
  version "AnyCom", "ECO Ethernet"
  bind "pcnet_cs"

card "Argosy EN210 Ethernet"
  version "PCMCIA LAN", "Ethernet"
  bind "pcnet_cs"

card "Asante FriendlyNet Ethernet"
  version "ASANTE", "FriendlyNet PC Card"
  bind "pcnet_cs"

card "Billionton LNT-10TB"
  version "Billionton", "LNT-10TB"
  bind "pcnet_cs"

card "Billionton LNT-10TN"
  version "PCMCIA", "LNT-10TN"
  bind "pcnet_cs"

card "California Access Ethernet"
  version "PCMCIAs", "ComboCard"
  bind "pcnet_cs"

card "CeLAN Ethernet"
  version "PCMCIA", "ETHERNET V1.0"
  bind "pcnet_cs"

card "CentreCOM LA-PCM V2 Ethernet"
  version "Allied Telesis, K.K.", "CentreCOM LA-PCM_V2"
  bind "pcnet_cs"

card "CNet CN30BC Ethernet"
  version "CNet  ", "CN30BC", "ETHERNET"
  bind "pcnet_cs"

card "CNet CN40BC Ethernet"
  version "CNet", "CN40BC Ethernet"
  bind "pcnet_cs"

card "Compaq Ethernet"
  version "Compaq", "Ethernet LAN Card"
  bind "xirc2ps_cs"

card "Compaq Netelligent 10/100 Ethernet"
  version "Compaq", "Netelligent 10/100 PC Card"
  bind "xirc2ps_cs"

card "COMPU-SHACK BASEline Ethernet"
  version "COMPU-SHACK", "BASEline PCMCIA 10 MBit Ethernetadapter"
  bind "pcnet_cs"

card "Connectware LANdingGear Ethernet"
  manfid 0x0057, 0x1004
  bind "pcnet_cs"

card "CONTEC Ethernet"
  version "CONTEC Co.,Ltd."
  bind "fmvj18x_cs"

card "Corega PCC-T Ethernet"
  version "corega K.K.", "corega Ether PCC-T"
  bind "pcnet_cs"

card "Corega PCC-T Ethernet"
  version "corega K.K.", "corega EtherII PCC-T"
  bind "pcnet_cs"

card "Corega PCC-T Ethernet"
  version "corega,K.K.", "Ethernet LAN Card"
  bind "pcnet_cs"

card "Corega PCM-T Ethernet"
  version "Corega,K.K.", "Ethernet LAN Card"
  bind "pcnet_cs"

card "CyQ've 10baseT Ethernet"
  version "CyQ've 10 Base-T LAN CARD"
  bind "pcnet_cs"

card "CyQ've ELA-010 Ethernet"
  version "CyQ've", "ELA-010"
  bind "pcnet_cs"

card "Danpex EN-6200P2 Ethernet"
  version "*", "EN-6200P2"
  bind "pcnet_cs"

card "DataTrek NetCard Ethernet"
  version "DataTrek.", "NetCard "
  bind "pcnet_cs"

card "Dayna Commnunications CommuniCard E Ethernet"
  version "Dayna Communications, Inc.", "CommuniCard E"
  bind "pcnet_cs"

card "Digital DEPCM-BA Ethernet"
  version "DIGITAL", "DEPCM-XX"
  bind "pcnet_cs"

card "Digital PCP78-AC Ethernet"
  version "Digital", "Ethernet", "Adapter"
  bind "pcnet_cs"

card "D-Link DE-650 Ethernet"
  version "D-Link", "DE-650"
  bind "pcnet_cs"

card "D-Link DFE-650 Ethernet"
  version "D-Link", "DFE-650"
  bind "pcnet_cs"

card "D-Link DE-660 Ethernet"
  version "D-Link", "DE-660"
  bind "pcnet_cs"

card "D-Link DE-660+ Ethernet"
  version "D-Link", "DE-660+"
  bind "pcnet_cs"

card "D-Link DE-650 Ethernet"
  tuple 0x40, 0x0009, "D-Link PC Ethernet Card"
  bind "pcnet_cs"

card "DynaLink L10C Ethernet"
  version "DYNALINK", "L10C"
  bind "pcnet_cs"

card "DynaLink L10BC Ethernet"
  version "DYNALINK", "L10BC"
  bind "pcnet_cs"

card "E2000 NE2000-Compatible Ethernet"
  version "Ethernet Adapter", "E2000 PCMCIA Ethernet"
  bind "pcnet_cs"

card "Eagle NE200 Ethernet"
  manfid 0x0004, 0x0004
  bind "fmvj18x_cs"

card "Edimax Ethernet Combo"
  version "Edimax Technology Inc.", "PCMCIA", "Ethernet Card"
  bind "pcnet_cs"

card "EFA 207 Ethernet"
  version "EFA   ", "EFA207", "ETHERNET"
  bind "pcnet_cs"

card "Eiger Labs EPX-ET10T2 Ethernet"
  version "EIGER Labs Inc.", "Ethernet Combo card"
  bind "pcnet_cs"

card "Eiger Labs EPX-ET10BT Ethernet"
  version "EIGER Labs Inc.", "Ethernet 10BaseT card"
  bind "pcnet_cs"

card "Eiger Labs EPX-10BT Ethernet"
  version "Eiger Labs,Inc", "EPX-10BT PC Card Ethernet 10BT"
  bind "fmvj18x_cs"

card "Eiger Labs EPX-ET 10BT Ethernet"
  version "Eiger labs,Inc.", "EPX-10BT PC Card Ethernet 10BT"
  bind "fmvj18x_cs"

card "ELECOM Laneed LD-CDF"
  version "Laneed", "LD-CDF"
  bind "pcnet_cs"

card "EZLink 4109 Ethernet"
  version "PCMCIA", "Ethernet Card"
  bind "pcnet_cs"

card "EP-210 Ethernet"
  version "Ethernet PCMCIA adapter", "EP-210"
  bind "pcnet_cs"

card "EP-210 Ethernet"
  version "EP-210 PCMCIA LAN CARD."
  bind "pcnet_cs"

card "EP-220 Ethernet"
  version "PCMCIA", "ETHERNET"
  bind "pcnet_cs"

card "Epson EEN10B Ethernet"
  version "Seiko Epson Corp.", "Ethernet"
  bind "pcnet_cs"

card "Farallon ENet"
  version "Farallon", "ENet"
  bind "3c589_cs"

card "Fujitsu FMV-J181 Ethernet"
  version "PCMCIA MBH10302"
  bind "fmvj18x_cs"

card "Fujitsu FMV-1080 Ethernet"
  version "FUJITSU", "MBH10308"
  bind "fmvj18x_cs"

card "Fujitsu FMV-J182 Ethernet"
  version "FUJITSU", "LAN Card(FMV-J182)"
  bind "fmvj18x_cs"

card "Fujitsu Towa LA501 Ethernet"
  version "FUJITSU TOWA", "LA501"
  bind "fmvj18x_cs"

card "Grey Cell GCS2000 Ethernet"
  version "Grey Cell", "GCS2000"
  bind "pcnet_cs"

card "Grey Cell GCS2220 Ethernet"
  version "Grey Cell", "GCS2220"
  bind "pcnet_cs"

card "GVC NIC-2000P Ethernet"
  version "GVC", "NIC-2000p"
  bind "pcnet_cs"

card "GVC NIC-2000P Ethernet"
  version "PCMCIA", "Ethernet Combo card"
  bind "pcnet_cs"

card "Hitachi HT-4840-11 Ethernet"
  version "HITACHI", "HT-4840-11"
  bind "fmvj18x_cs"

card "Hypertec EP401 Ethernet"
  version "Hypertec", "*", "EP401"
  bind "pcnet_cs"

card "IBM Credit Card Ethernet"
  version "IBM Corp.", "Ethernet"
  bind "pcnet_cs"

card "IC-Card Ethernet"
  version "IC-CARD", "IC-CARD"
  bind "pcnet_cs"

card "IC-Card Plus Ethernet"
  version "IC-CARD+", "IC-CARD+"
  bind "pcnet_cs"

card "Kansai KLA-PCM/T Ethernet"
  version "KANSAI ELECTRIC CO.,LTD", "KLA-PCM/T"
  bind "pcnet_cs"

card "Katron PE-520 Ethernet"
  version "KCI", "PE520 PCMCIA Ethernet Adapter"
  bind "pcnet_cs"

card "KingMax Technology Ethernet"
  version "KingMax Technology Inc.", "EN10-T2", "PCMCIA Ethernet Card"
  bind "pcnet_cs"

card "KingMax Technology Ethernet"
  version "KingMax Technology Inc.", "*", "Ethernet Card"
  bind "pcnet_cs"

card "KingMax Technology Ethernet"
  version "KINGMAX", "EN10T2T"
  bind "pcnet_cs"

card "Kingston KNE-PCM/x Ethernet"
  version "Kingston Technology Corp.", "EtheRx PC Card Ethernet Adapter"
  bind "pcnet_cs"

card "Kingston KNE-PC2 Ethernet"
  version "Kingston", "KNE-PC2"
  bind "pcnet_cs"

card "KTI PE-520 Plus Ethernet"
  version "KTI", "PE520 PLUS"
  cis "cis/PE520.dat"
  bind "pcnet_cs"

card "Linksys Ethernet"
  tuple 0x40, 0x0009, "E-CARD PC Ethernet Card"
  cis "cis/E-CARD.dat"
  bind "pcnet_cs"

card "Linksys Ethernet"
  version "LINKSYS", "E-CARD"
  bind "pcnet_cs"

card "Linksys Ethernet"
  version "E-CARD", "E-CARD"
  bind "pcnet_cs"

card "Linksys Ethernet"
  version "Linksys", "Combo PCMCIA EthernetCard (EC2T)"
  bind "pcnet_cs"

card "Longshine ShineNet LCS-8534 Ethernet"
  version "LONGSHINE", "PCMCIA Ethernet Card"
  bind "pcnet_cs"

card "Longshine ShineNet LCS-8534 Ethernet"
  version "LONGSHINE", "*", "EP401"
  bind "pcnet_cs"

card "Logitec LPM-LN10BA Ethernet"
  version "Cardwell", "PCMCIA", "ETHERNET"
  bind "pcnet_cs"

card "Logitec LPM-LN20T Ethernet"
  version "Logitec", "LPM-LN20T"
  bind "pcnet_cs"

card "MACNICA Ethernet"
  version "MACNICA", "ME1-JEIDA"
  bind "pcnet_cs"

card "Maxtech PCN2000 Ethernet"
  version "MAXTECH", "PCN2000"
  bind "pcnet_cs"

card "Megahertz CC10BT/2 Ethernet"
  version "Megahertz", "CC10BT/2"
  bind "smc91c92_cs"

card "Melco LPC2-T Ethernet"
  manfid 0x01bf, 0x2216
  bind "pcnet_cs"

card "Microdyne NE4200 Ethernet"
  version "Microdyne", "NE4200"
  bind "pcnet_cs"

card "Midori LT-PCMT Ethernet"
  version "MIDORI ELEC.", "LT-PCMT"
  bind "pcnet_cs"

card "National Semiconductor InfoMover 4100 Ethernet"
  version "National Semiconductor", "InfoMover 4100"
  bind "pcnet_cs"

card "National Semiconductor InfoMover NE4100 Ethernet"
  version "National Semiconductor", "InfoMover NE4100"
  bind "pcnet_cs"

card "NEC PC-9801N-J12 Ethernet"
  version "NEC", "PC-9801N-J12"
  bind "pcnet_cs"

card "New Media Ethernet"
  version "New Media Corporation", "Ethernet"
  bind "nmclan_cs"

card "New Media BASICS Ethernet"
  version "BASICS by New Media Corporation", "Ethernet", "SMC91C94"
  bind "smc91c92_cs"

card "New Media LanSurfer"
  manfid 0x0057, 0x0021
  bind "pcnet_cs"

card "NextCom NC5310 Ethernet"
  version "NextComK.K.", "NC5310 Ver1.0        "
  bind "fmvj18x_cs"

card "NE2000 Compatible Ethernet"
  version "PCMCIA", "Ethernet"
  bind "pcnet_cs"

card "NE2000 Compatible Ethernet"
  version "PCMCIA", "Ethernet 10BaseT Card"
  bind "pcnet_cs"

card "NE2000 Compatible Ethernet"
  version "NE2000 Compatible"
  bind "pcnet_cs"

card "NE2000 Compatible Ethernet"
  version "Ethernet", "Adapter"
  bind "pcnet_cs"

card "NE2000 Compatible Ethernet"
  version "PCMCIA", "PCMCIA-ETHERNET-CARD", "UE2620"
  bind "pcnet_cs"

card "NE2000 Compatible Ethernet"
  manfid 0x0149, 0xc1ab
  bind "pcnet_cs"

card "NDC Instant-Link Ethernet"
  version "NDC", "Ethernet"
  cis "cis/NE2K.dat"
  bind "pcnet_cs"

card "Novell Eagle 200T Ethernet"
  version "EAGLE Technology", "NE200 ETHERNET LAN MBH10302 04"
  bind "fmvj18x_cs"

card "Ositech Four of Diamonds Ethernet"
  version "Ositech", "Trumpcard:Four of Diamonds Ethernet"
  bind "smc91c92_cs"

card "IO DATA PCLA/T Ethernet"
  version "I-O DATA", "PCLA", "ETHERNET"
  bind "pcnet_cs"

card "IO DATA PCLA/TE Ethernet"
  version "IO DATA", "PCLATE", "ETHERNET"
  bind "pcnet_cs"

card "Panasonic CF-VEL211 Ethernet"
  version "Matsushita Electric Industrial Co.,LTD.", "CF-VEL211"
  bind "pcnet_cs"

card "Portable Add-ons Ethernet+"
  version "Portable Add-ons", "Ethernet+"
  bind "nmclan_cs"

card "PreMax PE-200 Ethernet"
  version "PMX   ", "PE-200"
  cis "cis/PE-200.dat"
  bind "pcnet_cs"

card "PRETEC CompactLAN Ethernet"
  version "PRETEC", "Ethernet CompactLAN 10baseT 3.3V"
  bind "pcnet_cs"

card "Psion Gold Card Ethernet"
  version "Psion Dacom", "Gold Card Ethernet"
  bind "pcnet_cs"

card "Psion Gold Card Netglobal Ethernet"
  version "Psion", "10Mb Ethernet"
  bind "smc91c92_cs"

card "RATOC Ethernet"
  version "PCMCIA LAN MBH10304  ES"
  bind "fmvj18x_cs"

card "RATOC REX-R280 Ethernet"
  version "RATOC System Inc.", "10BASE_T CARD R280"
  bind "fmvj18x_cs"

card "Relia RE2408T Ethernet"
  version "PCMCIA LAN", "Ethernet"
  bind "pcnet_cs"

card "Reliasys 2400A Ethernet"
  version "=RELIA==", "Ethernet"
  bind "pcnet_cs"

card "RPTI EP400 Ethernet"
  version "RPTI LTD.", "EP400"
  bind "pcnet_cs"

card "RPTI EP400 Ethernet"
  version "RPTI", "EP400 Ethernet NE2000 Compatible"
  bind "pcnet_cs"

card "RPTI EP401 Ethernet"
  version "RPTI", "EP401 Ethernet NE2000 Compatible"
  bind "pcnet_cs"

card "RPTI 1625B Ethernet"
  version "RP", "1625B Ethernet NE2000 Compatible"
  bind "pcnet_cs"

card "SCM Ethernet Combo"
  version "SCM", "Ethernet Combo card"
  bind "pcnet_cs"

card "Sky Link Express"
  version "2408LAN", "Ethernet"
  bind "pcnet_cs"

card "SMC EtherEZ Ethernet"
  version "SMC", "EtherEZ Ethernet 8020"
  bind "smc91c92_cs"

card "SMC EZCard-10 Ethernet"
  version "SMC", "EZCard-10-PCMCIA"
  bind "pcnet_cs"

card "Socket EA Ethernet"
  version "Socket Communications Inc",
    "Socket EA PCMCIA LAN Adapter Revision D"
  bind "pcnet_cs"

card "Socket EA Ethernet"
  version "Socket Communications Inc",
    "Socket EA PCMCIA LAN Adapter Revision E"
  bind "pcnet_cs"

card "Socket LP-E Ethernet"
  manfid 0x0104, 0x000d
  bind "pcnet_cs"

card "Socket LP-E CF+ Ethernet"
  manfid 0x0104, 0x0075
  bind "pcnet_cs"

card "SuperSocket Ethernet"
  version "Telecom Device K.K.", "SuperSocket RE450T"
  bind "pcnet_cs"

card "Surecom Ethernet"
  version "TAMARACK", "Ethernet"
  cis "cis/tamarack.dat"
  bind "pcnet_cs"

card "TDK LAC-CD02x Ethernet"
  version "TDK", "LAC-CD02x"
  bind "fmvj18x_cs"

card "TDK LAC-CF010 Ethernet"
  version "TDK", "LAC-CF010"
  bind "fmvj18x_cs"

card "TDK LAK-CD031 Ethernet"
  version "TDK", "LAK-CD031 for PCMCIA"
  bind "pcnet_cs"

card "Xircom IIps Ethernet"
  version "Xircom", "*", "PS-CE2-10"
  bind "xirc2ps_cs"

card "Xircom RE-10 Ethernet"
  version "Xircom", "*", "RE-10"
  bind "xirc2ps_cs"

#
# 10/100baseT network adapters
#
card "3Com 572/574 Fast Ethernet"
  manfid 0x0101, 0x0574
  bind "3c574_cs"

card "Abocom LinkMate FE1000 Fast Ethernet"
  version "Fast Ethernet", "Adapter"
  bind "pcnet_cs"

card "Accton Fast EtherCard-16"
  manfid 0x01bf, 0x010a
  bind "xirc2ps_cs"

card "Allied Telesis CentreCOM LA100-PCM-T V2"
  version "Allied Telesis, K.K.",
    "CentreCOM LA100-PCM-T V2 100/10M LAN PC Card"
  bind "pcnet_cs"

card "AmbiCom AMB8110 Fast Ethernet"
  manfid 0x021b, 0x0202
  bind "pcnet_cs"

card "AnyCom ECO 10/100 Fast Ethernet"
  version "AnyCom", "ECO Ethernet 10/100"
  bind "pcnet_cs"

card "Argosy EN220 Fast Ethernet"
  version "ARGOSY", "Fast Ethernet PCCard"
  bind "smc91c92_cs"

card "Ark Sky Link Express PA2600"
  manfid 0xffff, 0x1090
  bind "pcnet_cs"

card "Buffalo LPC3-CLX Fast Ethernet"
  manfid 0x026f, 0x0301
  bind "pcnet_cs"

card "COMPU-SHACK FASTline 10/100 Fast Ethernet"
  version "COMPU-SHACK", "FASTline PCMCIA 10/100 Fast-Ethernet"
  bind "pcnet_cs"

card "Corega PCC-TX Fast Ethernet"
  version "corega K.K.", "corega FastEther PCC-TX"
  bind "pcnet_cs"

card "Corega FEther PCC-TXF"
  version "corega", "FEther PCC-TXF"
  bind "pcnet_cs"

card "dit Co., Ltd., PC Card-10/100BTX"
  version "dit Co., Ltd.", "PC Card-10/100BTX"
  bind "smc91c92_cs"

card "D-Link Fast Ethernet"
  version "ETHER-C16"
  bind "pcnet_cs"

card "Dynalink L100C Fast Ethernet"
  version "DYNALINK", "L100C"
  bind "smc91c92_cs"

card "EXP ThinLan-110 Fast Ethernet"
  version "PCMCIA", "Fast Ethernet PCCard"
  bind "smc91c92_cs"

card "Farallon Enet"
  version "Farallon", "Farallon Enet"
  bind "smc91c92_cs"

card "Intel EtherExpress PRO/100"
  version "Intel", "EtherExpress(TM) PRO/100 PC Card Mobile Adapter16"
  bind "xirc2ps_cs"

card "IO DATA PCET/TX Fast Ethernet"
  version "IO DATA", "PCETTX"
  bind "pcnet_cs"

card "iPort 10/100 Fast Ethernet"
  version "iPort", "10/100 Ethernet Card"
  bind "pcnet_cs"

card "Laneed LD-10/100CD Fast Ethernet"
  version "Laneed", "LD-10/100CD"
  bind "pcnet_cs"

card "Level One 10/100 Fast Ethernet"
  version "Dual Speed", "10/100 PC Card"
  bind "pcnet_cs"

card "Linksys EtherFast 10/100 Fast Ethernet"
  version "Linksys", "EtherFast 10/100 PC Card (PCMPC100)"
  bind "pcnet_cs"

card "Logitec LPM-LN100TX Fast Ethernet"
  version "Logitec", "LPM-LN100TX"
  bind "pcnet_cs"

card "Melco LPC2-TX Fast Ethernet"
  version "MELCO", "LPC2-TX"
  bind "pcnet_cs"

card "Melco/SMC LPC-TX Fast Ethernet"
  version "MELCO/SMC", "LPC-TX"
  bind "smc91c92_cs"

card "Microcom C.E. Travel Card 10/100 Fast Ethernet"
  version "Microcom C.E.", "Travel Card LAN 10/100"
  bind "pcnet_cs"

card "NetGear FA410TXC Fast Ethernet"
  version "NETGEAR", "FA410TX"
  bind "pcnet_cs"

card "NE2000 Compatible Fast Ethernet"
  manfid 0x0149, 0x0230
  bind "pcnet_cs"

card "NE2000 Compatible Fast Ethernet"
  version "PCMCIA", "10/100 Ethernet Card"
  bind "pcnet_cs"

card "NE2000 Compatible Fast Ethernet"
  version "PCMCIA", "FAST ETHERNET CARD"
  bind "pcnet_cs"

card "Ositech Seven of Diamonds Fast Ethernet"
  version "Ositech", "Trumpcard:Seven of Diamonds Ethernet"
  bind "smc91c92_cs"

card "Planex FNW-3600T Fast Ethernet"
  version "Fast Ethernet", "Adapter"
  bind "pcnet_cs"

card "Psion Gold Card NetGlobal 10/100 Fast Ethernet"
  manfid 0x016c, 0x0023
  bind "smc91c92_cs"

card "Toshiba Advanced Network Fast Ethernet"
  version "Toshiba Information Systems", "*", "TPCENET"
  bind "xirc2ps_cs"

card "Toshiba 10/100 Fast Ethernet"
  version "Toshiba", "10/100 Ethernet PC Card"
  bind "xirc2ps_cs"

# These conflict with other cards!
#card "WiseCom WC-PC400 Fast Ethernet"
#  manfid 0x0186, 0x0100
#  bind "smc91c92_cs"
#card "WiseCom WC-PC400 Fast Ethernet"
#  manfid 0x8a01, 0xc1ab
#  bind "smc91c92_cs"

card "WiseCom iPort 10/100 Fast Ethernet"
  manfid 0x0274, 0x1103
  bind "pcnet_cs"

card "Xircom CompactCard Ethernet"
  version "Xircom", "*", "CFE-10"
  bind "pcnet_cs"

card "Xircom CE3-10/100 Fast Ethernet"
  version "Xircom", "*", "CE3-10/100"
  bind "xirc2ps_cs"

card "Xircom RealPort2 10/100 Fast Ethernet"
  version "Xircom", "*", "R2E-100BTX"
  bind "xirc2ps_cs"

card "Xircom XE2000 10/100 Fast Ethernet"
  version "Xircom", "*", "XE2000"
  bind "xirc2ps_cs"

#
# Wireless network adapters
#
card "350 Series Wireless LAN Adapter"
  manfid 0x015f, 0x000a
  bind "airo_cs"

card "Aironet PC4500"
  manfid 0x015f, 0x0005
  bind "airo_cs"

card "Aironet PC4800"
  manfid 0x015f, 0x0007
  bind "airo_cs"

card "AT&T WaveLAN Adapter"
  version "AT&T", "WaveLAN/PCMCIA"
  bind "wavelan_cs"

card "Cabletron RoamAbout 802.11 DS"
  version "Cabletron", "RoamAbout 802.11 DS"
  bind "wvlan_cs"

card "Compaq WL100 11 Mbps Wireless Adapter"
  manfid 0x0138, 0x0002
  bind "wvlan_cs"

card "Digital RoamAbout/DS"
  version "Digital", "RoamAbout/DS"
  bind "wavelan_cs"

card "ELSA AirLancer MC-11"
  version "ELSA", "AirLancer MC-11"
  bind "wvlan_cs"

card "Lucent Technologies WaveLAN Adapter"
  version "Lucent Technologies", "WaveLAN/PCMCIA"
  bind "wavelan_cs"

card "Intersil PRISM2 11 Mbps Wireless Adapter"
  manfid 0x0156, 0x0002
  bind "wvlan_cs"

card "Lucent Technologies WaveLAN/IEEE Adapter"
  version "Lucent Technologies", "WaveLAN/IEEE"
  bind "wvlan_cs"

card "MELCO WLI-PCM-L11"
  version "MELCO", "WLI-PCM-L11"
  bind "wvlan_cs"

card "NCR WaveLAN Adapter"
  version "NCR", "WaveLAN/PCMCIA"
  bind "wavelan_cs"

card "NCR WaveLAN/IEEE Adapter"
  version "NCR", "WaveLAN/IEEE"
  bind "wvlan_cs"

card "RayLink PC Card WLAN Adapter"
  manfid 0x01a6, 0x0000
  bind "ray_cs"

card "Xircom CreditCard Netwave"
  version "Xircom", "CreditCard Netwave"
  bind "netwave_cs"

#
# Modems and other serial devices
#
# NOTE: most modems do not need explicit entries here, because they
# are correctly identified using the following generic entry.
#
card "Serial or Modem"
  function serial_port
  bind "serial_cs"

card "3Com 3CCM156 56K Global Modem"
  manfid 0x0101, 0x0039
  bind "serial_cs"

card "Angia Fax/Modem"
  version "Intelligent", "ANGIA FAX/MODEM"
  bind "serial_cs"

card "Bullet V.34 28.8K Modem"
  version "OEM      ", "C288MX     "
  bind "serial_cs"

card "Cirrus Logic 14.4K Fax Modem"
  version "CIRRUS LOGIC", "FAX MODEM"
  bind "serial_cs"

card "Compaq 28.8K Modem"
  version "COMPAQ", "PCMCIA 28800 FAX/DATA MODEM"
  bind "serial_cs"

card "Compaq 33.6K Modem"
  version "COMPAQ", "PCMCIA 33600 FAX/DATA MODEM"
  bind "serial_cs"

card "Dr. Neuhaus 14.4K FURY Card"
  version "Dr. Neuhaus", "FURY CARD 14K4"
  bind "serial_cs"

card "E.TECH Bullet 33.6K Modem"
  version "PCMCIA   ", "C336MX     "
  bind "serial_cs"

card "Gateway 2000 TelePath Fax Modem"
  version "GATEWAY2000", "CC3144", "*", "PCMCIA MODEM"
  bind "serial_cs"

card "Intel-compatible Modem"
  version "Intel", "MODEM 2400+"
  bind "serial_cs"

card "Macronix Fax/Modem"
  version "MACRONIX", "FAX/MODEM"
  bind "serial_cs"

card "Megahertz PCMCIA Modem"
  version "MEGAHERTZ", "*", "*", "PCMCIA MODEM"
  bind "serial_cs"

card "Megahertz V.34 Modem"
  version "MEGAHERTZ", "*", "V.34 PCMCIA MODEM"
  bind "serial_cs"

card "MultiTech MultiModem"
  version "Multi-Tech", "MT1432LT"
  bind "serial_cs"

card "MultiTech V.34 Modem"
  version "Multi-Tech", "MT2834LT"
  bind "serial_cs"

card "MultiTech MT5634ZLX"
  version "MultiTech", "PCMCIA 56K DataFax"
  cis "cis/MT5634ZLX.dat"
  bind "serial_cs"

card "Toshiba T144PF Modem"
  version "TOSHIBA", "T144PF", "*", "PCMCIA MODEM"
  bind "serial_cs"

card "Advantech COMpad-32/85"
  version "ADVANTECH", "COMpad-32/85", "1.0"
  cis "cis/COMpad2.dat"
  bind "serial_cs"

card "Advantech COMpad-32/85B-4"
  version "ADVANTECH", "COMpad-32/85B-4"
  cis "cis/COMpad4.dat"
  bind "serial_cs"

card "Advantech COMpad-32/85"
  version "ADV", "*", "TECH", "COMpad-32/85"
  bind "serial_cs"

card "Argosy Dual Serial I/O"
  version "*", "RS-COM 2P"
  cis "cis/RS-COM-2P.dat"
  bind "serial_cs"

card "Brain Boxes 2-Port RS-232"
  manfid 0x0160, 0x0002
  bind "serial_cs" to 0, "serial_cs" to 1

card "Computerboards PCM-COM422"
  version "Computerboards, Inc.", "PCM-COM422"
  bind "serial_cs"

card "Fujitsu FMV-JMD711"
  version "FUJITSU", "FC14F ", "MBH10213"
  bind "serial_cs"

card "IOTech Dual RS-232"
  version "IOTech Inc ", "PCMCIA Dual RS-232 Serial Port Card"
  bind "serial_cs"

card "National Instruments PCMCIA-232"
  manfid 0x10b, 0x0d50
  bind "serial_cs"

card "National Instruments PCMCIA-232/2"
  manfid 0x10b, 0x0d51
  bind "serial_cs"

card "National Instruments PCMCIA-485"
  manfid 0x10b, 0x0d52
  bind "serial_cs"

card "National Instruments PCMCIA-485/2"
  manfid 0x10b, 0x0d53
  bind "serial_cs"

card "National Instruments PCMCIA-232/4"
  manfid 0x10b, 0xd180
  bind "serial_cs"

card "Omega Engineering QSP-100"
  manfid 0x0137, 0x0025
  bind "serial_cs"

card "Quatech Dual RS-232"
  version "Quatech Inc", "PCMCIA Dual RS-232 Serial Port Card"
  bind "serial_cs"

card "Quatech Quad RS-232"
  manfid 0x0137, 0x001b
  bind "serial_cs"

card "Silicom 2S100 Dual Serial"
  manfid 0x0089, 0x0301
  bind "serial_cs"

card "Socket Communications Dual RS-232"
  manfid 0x0104, 0x0006
  bind "serial_cs"

card "Socket Communications Dual I/O Card"
  manfid 0x0104, 0x0070
  bind "serial_cs" to 0, "serial_cs" to 1

#
# Memory cards
#
card "Anonymous Memory"
  anonymous
  bind "memory_cs"

card "Memory Card"
  function memory_card
  bind "memory_cs"

card "IBM 2MB SRAM"
  version "IBM", "2MB SRAM"
  bind "memory_cs"

card "IBM 4MB Series 1 Flash"
  version "IBM", "4MB FLASH"
  bind "memory_cs", "ftl_cs"

card "IBM 8MB Series 2 Flash"
  version "IBM", "8MB FLASH"
  bind "memory_cs", "ftl_cs"

card "Intel Series 2 2MB Flash"
  version "intel", "SERIES2-02 "
  bind "memory_cs", "ftl_cs"

card "Intel Series 2 4MB Flash"
  version "intel", "SERIES2-04 "
  bind "memory_cs", "ftl_cs"

card "Intel Series 2 20MB Flash"
  version "intel", "SERIES2-20 "
  bind "memory_cs", "ftl_cs"

card "Intel Series 2+ 8MB Flash"
  version "Intel", "S2E8 SW"
  bind "memory_cs", "ftl_cs"

card "Intel Series 2+ 20MB Flash"
  version "Intel", "S2E20SW"
  bind "memory_cs", "ftl_cs"

card "Intel Series 100 Flash"
  version "intel", "VALUE SERIES 100 "
  bind "memory_cs", "ftl_cs"

card "IO DATA 2MB SRAM"
  version "IO DATA", "PCS-2M", "2MB SRAM"
  bind "memory_cs"

card "Maxtor MobileMax Flash"
  version "Maxtor", "MAXFL MobileMax Flash Memory Card"
  bind "memory_cs", "ftl_cs"

card "Seiko/Epson WWB101EN20"
  version "SEIKO EPSON", "WWB101EN20"
  bind "memory_cs"

card "Seiko/Epson WWB513EN20"
  version "SEIKO EPSON", "WWB513EN20"
  bind "memory_cs"

card "Franklink/Rolodex REX-3000"
  version "Starfish, Inc.", "REX-3000"
  bind "memory_cs"

card "Franklink/Rolodex REX-4100"
  version "Starfish, Inc.", "REX-4100"
  bind "memory_cs"

card "Kingmax 256K SRAM"
  version "KINGMAX TECHNOLOGY INC.", "SRAM 256K Bytes"
  bind "memory_cs"

#card "RATOC SmartMedia Adapter"
#  version "RATOC Systems,Inc.", "SmartMedia ADAPTER PC Card"
#  bind "memory_cs", "ftl_cs"

#
# Memory Technology Drivers
#
region "Generic or SRAM"
  default
  mtd "sram_mtd"

region "Intel Series 2 Flash"
  jedec 0x89 0xa2
  mtd "iflash2_mtd"

region "Intel Series 100 Flash"
  jedec 0x89 0xaa
  mtd "iflash2_mtd"

region "Intel Series 2+ Flash"
  jedec 0x89 0xa0
  mtd "iflash2+_mtd"

#
# Token Ring adapters
#
card "3Com TokenLink Velocity Adapter"
  version "3Com", "TokenLink Velocity PC Card"
  bind "ibmtr_cs"

card "IBM Token Ring Adapter"
  version "IBM", "TOKEN RING"
  bind "ibmtr_cs"

#
# SCSI host adapters
#
card "Adaptec APA-1460 SlimSCSI"
  version "Adaptec, Inc.", "APA-1460 SCSI Host Adapter"
  bind "aha152x_cs"

card "Eiger Labs SCSI"
  version "EIger Labs", "PCMCIA-to-SCSI Adapter"
  bind "qlogic_cs"

card "Epson SC200 SCSI"
  version "EPSON", "SCSI-2 PC Card SC200"
  bind "qlogic_cs"
  
card "IBM SCSI"
  version "IBM Corp.", "SCSI PCMCIA Card"
  bind "fdomain_cs"

card "IBM SCSI"
  version "SCSI PCMCIA Adapter Card"
  bind "fdomain_cs"

#card "MACNICA mPS100 SCSI"
#  version "MACNICA", "MIRACLE SCSI", "mPS100"
#  bind "qlogic_cs"

card "MACNICA mPS110 SCSI"
  version "MACNICA", "MIRACLE SCSI-II mPS110"
  bind "qlogic_cs"

card "Midori CN-SC43 SCSI"
  version "MIDORI ELECTRONICS ", "CN-SC43"
  bind "qlogic_cs"

card "NEC PC-9801N-J03R SCSI"
  version "NEC", "PC-9801N-J03R"
  bind "qlogic_cs"

card "New Media Bus Toaster SCSI"
  version "New Media", "SCSI", "Bus Toaster"
  bind "aha152x_cs"

card "New Media Toast & Jam Sound/SCSI"
  version "New Media Corporation", "Multimedia Sound/SCSI"
  bind "aha152x_cs"

card "Noteworthy Bus Toaster SCSI"
  version "NOTEWORTHY", "SCSI", "Bus Toaster"
  bind "aha152x_cs"

card "New Media BASICS SCSI"
  version "BASICS by New Media Corporation", "SCSI Sym53C500"
  bind "sym53c500_cs"

card "New Media Bus Toaster SCSI"
  version "New Media Corporation", "SCSI Bus Toaster Sym53C500"
  bind "sym53c500_cs"

card "Panasonic KXLC003"
  version "KME ", "KXLC003"
  bind "qlogic_cs"

card "Panasonic KXLC004"
  version "KME ", "KXLC004"
  bind "qlogic_cs"

card "Panasonic KXLC101"
  version "KME", "KXLC101"
  bind "qlogic_cs"

card "Qlogic FastSCSI"
  version "QLOGIC CORPORATION", "pc05"
  bind "qlogic_cs"

card "Qlogic FastSCSI"
  version "QLOGIC CORPORATION", "pc05 rev 1.10"
  bind "qlogic_cs"

card "Raven CD-Note SCSI"
  version "KME", "KXLC002", "00"
  bind "qlogic_cs"

card "RATOC REX-9530 SCSI-2"
  version "RATOC System Inc.", "SCSI2 CARD 37"
  bind "qlogic_cs"

card "SIMA TECH SCSI9000"
  version "*", "SCSI9000"
  bind "sym53c500_cs"

card "Simple Technology SCSI"
  version " SIMPLE TECHNOLOGY Corporation",
    "SCSI PCMCIA Credit Card Controller"
  bind "fdomain_cs"

card "Toshiba SCSC200A SCSI"
  version "TOSHIBA", "SCSC200A PC CARD SCSI"
  bind "qlogic_cs"

card "Toshiba SCSC200B SCSI"
  version "TOSHIBA", "SCSC200B PC CARD SCSI-10"
  bind "qlogic_cs"

#
# IEEE1394/FireWire cards
#
card "Cherri IEEE-1394"
  pci 0x104c, 0x8019
  bind "ohci1394_cb"

card "Newer Technology FireWire 2 Go"
  pci 0x104c, 0x8000
  bind "pcilynx_cb"

card "Western Digital 1394 Adapter"
  pci 0x1033, 0x00cd
  bind "ohci1394_cb"

#
# Multifunction cards
#
card "3Com 3c562/3c563 Ethernet/Modem"
  manfid 0x0101, 0x0562
  bind "3c589_cs" to 0, "serial_cs" to 1

card "3Com/Megahertz 3CXEM556 Ethernet/Modem"
  manfid 0x0101, 0x0035
  cis "cis/3CXEM556.dat"
  bind "3c589_cs" to 0, "serial_cs" to 1

card "3Com/Megahertz 3CXEM556 B-INT Ethernet/Modem"
  manfid 0x0101, 0x003d
  cis "cis/3CXEM556.dat"
  bind "3c589_cs" to 0, "serial_cs" to 1

card "3Com/Megahertz 3CCFEM556 Ethernet/Modem"
  manfid 0x0101, 0x0556
  cis "cis/3CCFEM556.dat"
  bind "3c574_cs" to 0, "serial_cs" to 1

card "Accton EN2218 LAN/Modem"
  version "PCMCIA", "EN2218-LAN/MODEM"
  cis "cis/PCMLM28.dat"
  bind "pcnet_cs", "serial_cs"

card "Accton UE2218 LAN/Modem"
  version "PCMCIA", "UE2218-LAN/MODEM"
  cis "cis/PCMLM28.dat"
  bind "pcnet_cs", "serial_cs"

card "AnyCom Fast Ethernet/Modem"
  version "AnyCom", "Fast Ethernet + 56K COMBO"
  bind "pcnet_cs", "serial_cs"

card "Apex MultiCard Ethernet/Modem"
  version "APEX DATA", "MULTICARD", "ETHERNET-MODEM"
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "Billionton LM5LT-10B Ethernet/Modem"
  manfid 0x021b, 0x0101
  bind "pcnet_cs", "serial_cs"

card "Compaq Microcom CPQ550 Ethernet/Modem"
  manfid 0x0138, 0x110a
  bind "xirc2ps_cs", "serial_cs"

card "Dayna Communicard Ethernet/Modem"
  version "DAYNA COMMUNICATIONS", "LAN AND MODEM MULTIFUNCTION"
  cis "cis/DP83903.dat"
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "D-Link DME336T Ethernet/Modem"
  version "D-Link", "DME336T"
  bind "pcnet_cs", "serial_cs"

card "D-Link DMF560TX Ethernet/Modem"
  manfid 0x0143, 0xc0ab
  bind "pcnet_cs", "serial_cs"

card "Gateway Telepath Ethernet/Modem"
  version "Gateway 2000", "XJEM3336"
  bind "smc91c92_cs", "serial_cs"

card "Grey Cell GCS3400 Ethernet/Modem"
  version "Grey Cell", "GCS3000"
  bind "pcnet_cs", "serial_cs"

card "IBM Home and Away Ethernet/Modem"
  version "IBM", "Home and Away Credit Card Adapter"
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "IBM Home and Away 28.8 Ethernet/Modem"
  version "IBM", "Home and Away 28.8 PC Card       "
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "IBM w95 Home and Away Ethernet/Modem"
  version "IBM", "w95 Home and Away Credit Card "
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "Intel EtherExpress PRO/100 LAN/Modem"
  manfid 0x0089, 0x110a
  bind "xirc2ps_cs", "serial_cs"

card "No-Name Ethernet/Modem"
  version "*", "FAX/Modem/Ethernet Combo Card "
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "Linksys LANmodem 28.8"
  version "LINKSYS", "PCMLM28"
  cis "cis/PCMLM28.dat"
  bind "pcnet_cs", "serial_cs"

card "Linksys LANmodem 33.6"
  version "LINKSYS", "PCMLM336"
  bind "pcnet_cs", "serial_cs"

card "Linksys EtherFast LANmodem 56K"
  version "Linksys", "EtherFast 10&100 + 56K PC Card (PCMLM56)"
  bind "pcnet_cs", "serial_cs"

card "Megahertz CC/XJEM1144 Ethernet/Modem"
  version "MEGAHERTZ", "XJEM1144/CCEM1144", "PCMCIA MODEM"
  bind "smc91c92_cs", "serial_cs"

card "Megahertz CC/XJEM1144 Ethernet/Modem"
  version "MEGAHERTZ", "XJEM1144/CCEM1144"
  bind "smc91c92_cs", "serial_cs"

card "Megahertz EM1144T Ethernet/Modem"
  version "MEGAHERTZ", "EM1144T", "PCMCIA MODEM"
  bind "smc91c92_cs", "serial_cs"

card "Megahertz CC/XJEM3288 Ethernet/Modem"
  version "MEGAHERTZ", "CC/XJEM3288", "DATA/FAX/CELL ETHERNET MODEM"
  bind "smc91c92_cs", "serial_cs"

card "Megahertz CC/XJEM3336 Ethernet/Modem"
  version "MEGAHERTZ", "CC/XJEM3336", "DATA/FAX/CELL ETHERNET MODEM"
  bind "smc91c92_cs", "serial_cs"

card "Motorola Marquis Ethernet/Modem"
  version "Motorola MARQUIS"
  bind "3c589_cs" to 0, "serial_cs" to 1

card "Motorola Mariner Ethernet/Modem"
  manfid 0x0109, 0x0501
  bind "smc91c92_cs", "serial_cs"

card "New Media LANSurfer 10+56 Ethernet/Modem"
  manfid 0x08a1, 0xc0ab
  bind "pcnet_cs", "serial_cs"

card "NSC DP83903-based Ethernet/Modem"
  version "*", "*", "*", "NSC MF LAN/Modem"
  cis "cis/DP83903.dat"
  bind "pcnet_cs" to 0, "serial_cs" to 1

card "Ositech Jack of Diamonds Ethernet/Modem"
  version "Ositech", "Trumpcard:Jack of Diamonds Modem+Ethernet"
  bind "smc91c92_cs", "serial_cs"

card "Ositech Jack of Hearts Ethernet/Modem"
  version "Ositech", "Trumpcard:Jack of Hearts Modem+Ethernet"
  bind "smc91c92_cs", "serial_cs"

card "Ositech Jack of Hearts Ethernet/Modem"
  manfid 0x0140, 0x000a
  bind "smc91c92_cs", "serial_cs"

card "Psion Gold Card V34 Ethernet"
  version "Psion Dacom", "Gold Card V34 Ethernet"
  cis "cis/PCMLM28.dat"
  bind "pcnet_cs", "serial_cs"

card "Psion Gold Card V34 Ethernet"
  version "Psion Dacom", "Gold Card V34 Ethernet GSM"
  cis "cis/PCMLM28.dat"
  bind "pcnet_cs", "serial_cs"

card "Psion Gold Card Netglobal 56K+10Mb Ethernet"
  manfid 0x016c, 0x0020
  bind "smc91c92_cs" to 0, "serial_cs" to 1

card "Rover ComboCard Ethernet/Modem"
  version "PCMCIAs", "ComboCard"
  bind "pcnet_cs", "serial_cs"

card "Socket ES-1000 Ethernet/RS-232"
  manfid 0x0104, 0x000a
  bind "pcnet_cs", "serial_cs"
 
card "TDK Global Networker Ethernet/Modem"
  version "TDK", "GlobalNetworker 3410/3412"
  bind "serial_cs"

card "TDK 3000/3400/5670 Fast Ethernet/Modem"
  manfid 0x0143, 0x3341
  bind "pcnet_cs", "serial_cs"

card "TDK DFL5610WS Ethernet/Modem"
  manfid 0x0105, 0xea15
  bind "pcnet_cs", "serial_cs"

card "Telecom Device SuperSocket LM336 Ethernet/Modem"
  version "PCMCIAs", "LanModem"
  bind "pcnet_cs", "serial_cs"

card "Xircom CE II Ethernet/Modem"
  version "Xircom", "CreditCard Ethernet+Modem II"
  bind "xirc2ps_cs", "serial_cs"

card "Xircom CEM28 Ethernet/Modem"
  version "Xircom", "*", "CEM28"
  bind "xirc2ps_cs", "serial_cs"

card "Xircom CEM33 Ethernet/Modem"
  version "Xircom", "*", "CEM33"
  bind "xirc2ps_cs", "serial_cs"

card "Xircom CEM56 Ethernet/Modem"
  version "Xircom", "*", "CEM56"
  bind "xirc2ps_cs", "serial_cs"

card "Xircom RealPort REM10BT Ethernet/Modem"
  version "Xircom", "*", "REM10"
  bind "xirc2ps_cs", "serial_cs"

card "Xircom XEM5600 Ethernet/Modem"
  version "Xircom", "*", "XEM5600"
  bind "xirc2ps_cs", "serial_cs"

#
# ATA/IDE fixed disk devices
#
card "ATA/IDE Fixed Disk"
  function fixed_disk
  bind "ide_cs"

card "ACE DoubleFlash 20MB"
  version "IBM", "IBM17JSSFP20"
  bind "ide_cs"

card "Argosy EIDE CD-ROM"
  version "ARGOSY", "CD-ROM"
  bind "ide_cs"

card "Argosy PnPIDE"
  version "ARGOSY", "PnPIDE"
  bind "ide_cs"

card "Caravelle CD-36N/CD-36E CD-ROM"
  version "Caravelle", "PSC-IDE ", "PSC000"
  bind "ide_cs"

card "CNF CARDport CD-ROM"
  version "CNF CD-M", "CD-ROM"
  bind "ide_cs"

card "Creative Technology CD-ROM"
  version "Creative Technology Ltd.", "PCMCIA CD-ROM Interface Card"
  bind "ide_cs"

card "Digital Mobile Media CD-ROM"
  version "Digital Equipment Corporation.", "Digital Mobile Media CD-ROM"
  bind "ide_cs"

card "EXP CD940 CD-ROM"
  version "EXP   ", "CD-ROM"
  bind "ide_cs"

card "EXP PnPIDE"
  version "EXP   ", "PnPIDE"
  bind "ide_cs"

card "EXP Traveler 620 CD-ROM"
  version "EXP", "CD+GAME", "C1"
  bind "ide_cs"

card "Freecom IQ-drive"
  version "FREECOM", "PCCARD-IDE"
  bind "ide_cs"

card "Generic ATAPI CD-ROM"
  version "PCMCIA", "CD-ROM"
  bind "ide_cs"

card "IBM Max Portable CD-ROM"
  manfid 0x00a4, 0x002d
  bind "ide_cs"

card "IBM Portable Drive Bay"
  version "PCMCIA", "IDE CARD", "F1"
  bind "ide_cs"

card "IO DATA CDP-TX/PCIDE"
  version "IO DATA", "PCIDE"
  bind "ide_cs"

card "IO DATA PCIDE II"
  version "IO DATA", "PCIDEII"
  bind "ide_cs"

card "IO DATA CBIDE"
  version "WIT", "IDE16"
  bind "ide_cs"

card "IO DATA CBIDE2"
  version "IO DATA", "CBIDE2      "
  bind "ide_cs"

card "MCD601p CD-ROM"
  version "CDROM", "IDE", "MCD-601p"
  bind "ide_cs"

card "Ninja ATA"
  version " ", "NinjaATA-"
  bind "ide_cs"

card "PCMCIA PnPIDE"
  version "PCMCIA", "PnPIDE"
  bind "ide_cs"

card "Simple Tech Compact Flash"
  version "STI Flash"
  bind "ide_cs"

card "Toshiba CD-ROM"
  version "LOOKMEET", "CBIDE2      "
  bind "ide_cs"

#
# Non-ATA/IDE CD-ROM's
#
card "Innovative Communications CyberRom CD"
  version "Innovative Communications", "CyberRom CD"
  bind "oti12_cs"

#
# Miscellaneous card definitions
#
#card "Canon FDCard"
#  version "Canon Electronics INC.", "FDCard Ver. 1.00"
#
#card "New Media .WAVjammer"
#version "New Media Corporation", ".WAVjammer"

card "IBM Smart Capture Card"
  version "IBM Corp.", "Video Capture"
  bind "iscc_cs"

card "Parallel Port Card"
  function parallel_port
  bind "parport_cs"

card "Quatech SPP-100 Parallel Port Card"
  manfid 0x0137, 0x0003
  bind "parport_cs"

card "TELES S0/PC ISDN"
  version "TELES", "S0/PC"
  bind "teles_cs"

#
# CardBus cards
#
card "3Com 3c575-TX Fast EtherLink XL"
  manfid 0x0101, 0x5057
  bind "3c575_cb"

card "3Com 3CCFE575B/3CXFE575B Fast EtherLink XL"
  manfid 0x0101, 0x5157
  bind "3c575_cb"

card "3Com 3CCFE575CT/3CXFE575CT Fast EtherLink XL"
  manfid 0x0101, 0x5257
  bind "3c575_cb"

card "3Com 3CCFEM656B w/Winmodem"
  manfid 0x0102, 0x6560
  bind "3c575_cb"

card "3Com 3CCFEM656B w/Winmodem"
  manfid 0x0102, 0x6562
  bind "3c575_cb"

card "3Com 3CXFEM656C w/Winmodem"
  manfid 0x0102, 0x6564
  bind "3c575_cb"

card "Accton EN2220 Fast Ethernet"
  version "Accton", "EN2220 CardBus Fast Ethernet Card"
  bind "tulip_cb"

card "Accton EN2227 Fast Ethernet"
  manfid 0x01bf, 0x2227
  bind "tulip_cb"

card "Adaptec APA-1480 SCSI Host Adapter"
  manfid 0x012f, 0xcb01
  bind "apa1480_cb"

#Conflicts with corega PCC-T!
#card "Allied Telesyn AT-2800 10/100 Fast Ethernet"
#  manfid 0xc00f, 0x0000
#  bind "tulip_cb"

card "Ambicom AMB8100 Fast Ethernet"
  manfid 0x9513, 0x0081
  bind "tulip_cb"

card "AmbiCom CB100-EZ EzPort Fast Ethernet"
  manfid 0x022d, 0x2103
  bind "tulip_cb"

card "Asante FriendlyNET 10/100 CardBus"
  version "Asante", "FriendlyNET 10/100 CardBus"
  bind "tulip_cb"

card "Billionton LND-100B Fast Ethernet"
  version "Billionton", "LND-100B"
  bind "tulip_cb"

card "D-Link DFE-660 Fast Ethernet"
  manfid 0x50c7, 0xcafe
  bind "tulip_cb"

card "Farallon EtherTX 10/100 Fast Ethernet"
  version "Farallon", "10/100", "Ethernet"
  bind "tulip_cb"

card "Fujitsu FMV-J184 Fast Ethernet"
  version "FUJITSU", "LAN Card(100BASE-TX)(FMV-J184)"
  bind "tulip_cb"

card "Fujitsu FMV-J185 Fast Ethernet"
  version "FUJITSU", "LAN Card(100BASE-TX)(FMV-J185)"
  bind "eepro100_cb"

card "Genius MF3000 Fast Ethernet"
  version "CardBus", "10/100Mbps LanCard"
  bind "tulip_cb"

card "IBM 10/100 EtherJet CardBus"
  manfid 0x00a4, 0x0113
  bind "tulip_cb"

card "IBM 10/100 EtherJet 56K CardBus"
  manfid 0x00a4, 0x0103
  bind "tulip_cb" to 0, "serial_cb" to 1

card "Intel EtherExpress PRO/100 CardBus"
  manfid 0x0089, 0x0102
  bind "tulip_cb"

card "Intel EtherExpress PRO/100 CardBus"
  manfid 0x0089, 0x0113
  bind "tulip_cb"

card "Intel EtherExpress PRO/100 CardBus II"
  manfid 0x0089, 0x0103
  bind "eepro100_cb"

card "Intel EtherExpress PRO/100 LAN+Modem 56K CardBus II"
  manfid 0x0089, 0x1103
  bind "eepro100_cb" to 0, "serial_cb" to 1

card "Kingston KNE-CB4TX Fast Ethernet"
  manfid 0x0186, 0x0101
  bind "tulip_cb"

card "Linksys EtherFast 10/100"
  manfid 0x0149, 0x0231
  bind "tulip_cb"

card "Linksys EtherFast 10/100"
  manfid 0x0149, 0xc2ab
  bind "tulip_cb"

card "Linksys EtherFast PCMPC200 v2"
  manfid 0x13d1, 0xab02
  bind "tulip_cb"

card "Linksys EtherFast PCMPC200 v2"
  manfid 0x13d1, 0xab03
  bind "tulip_cb"

card "Macsense MPC-200 Fast Ethernet"
  version "Macsense", "MPC-200"
  bind "tulip_cb"

card "NDC Communications Sohoware NCB100 Fast Ethernet"
  version "NDC Communications, Inc.", "NCB100"
  bind "tulip_cb"

card "NDC NCB100 Fast Ethernet"
  manfid 0xe815, 0x0081
  bind "tulip_cb"

card "NetGear FA510C Fast Ethernet"
  manfid 0x9513, 0x0081
  bind "tulip_cb"

card "PLANET ENW-3502-FC"
  version "PLANET", "ENW-3502-FC"
  bind "tulip_cb"

card "PrimeXPress 10/100 Fast Ethernet"
  manfid 0x021b, 0x0510
  bind "tulip_cb"

card "RATOC REX-CB80 Fast Ethernet"
  version "RATOC Systems,Inc.", "CardBus LAN 01"
  bind "tulip_cb"

card "Silicom FEM56 Fast Ethernet"
  manfid 0x01da, 0x0090
  bind "tulip_cb"

card "SMC EZ 10/100 Fast Ethernet"
  manfid 0x01bf, 0x2220
  bind "tulip_cb"

card "SMC EZ 10/100 Fast Ethernet"
  manfid 0x01bf, 0x2225
  bind "tulip_cb"

#card "SVEC 10/100 Fast Ethernet"
#  manfid 0x8a01, 0x0100
#  bind "tulip_cb"

card "TDK NetworkFlyer 10/100 Fast Ethernet"
  manfid 0x0105, 0x0500
  bind "tulip_cb"

card "Tulip-based CardBus Fast Ethernet"
  version "CardBus", "10/100Mbps LAN Card"
  bind "tulip_cb"

card "UMAX Technologies UMAX250 Fast Ethernet"
  manfid 0x9513, 0x0081
  bind "tulip_cb"

card "Ositech Seven of Spades Fast Ethernet"
  manfid 0x0140, 0x0011
  bind "epic_cb"

card "Ositech Jack of Spades Fast Ethernet/Modem"
  manfid 0x0140, 0x000f
  bind "epic_cb" to 0, "serial_cb" to 1

card "Ositech Jack of Spades Fast Ethernet/Modem"
  manfid 0x0140, 0x0012
  bind "epic_cb" to 0, "serial_cb" to 1

card "Psion Gold Card Netglobal 56K+10/100Mb CardBus"
  manfid 0x016c, 0x0021
  bind "epic_cb" to 0, "serial_cb" to 1

card "Xircom CBEII-10/100 CardBus 10/100 Ethernet"
  version "Xircom", "*", "CBEII-10/100"
  bind "tulip_cb"

card "Xircom R2BE-100BTX CardBus 10/100 Ethernet"
  version "Xircom", "*", "R2BE-100BTX"
  bind "tulip_cb"

card "Xircom CBEM56G-100 CardBus 10/100 Ethernet + 56K Modem"
  version "Xircom", "*", "CBEM56G"
  bind "tulip_cb" to 0, "serial_cb" to 1

card "Xircom R2BEM56G-100 CardBus 10/100 Ethernet + 56K Modem"
  version "Xircom", "*", "R2BEM56G"
  bind "tulip_cb" to 0, "serial_cb" to 1

card "Xircom RBM56G Modem"
  pci 0x115d, 0x0101
  bind "serial_cb"

# Include configuration files for add-on drivers

source ./*.conf

# Include local configuration settings

source ./config.opts
