/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (Windows)                            */
/*    ߽                                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* ߤΥߥ졼(ITRONȤ̵طΥåɤƤ֤) */
void hospac_win_int(INTNO intno)
{
	T_HOSPAC_CTXINF *ctxinf;

	/* ϰϥå */
	if ( intno < KERNEL_TMIN_INTNO || intno > KERNEL_TMAX_INTNO )
	{
		return;
	}

	/* ޥե */
	WaitForSingleObject(hospac_hSem, INFINITE);

	/* ¹楹åɤ򥵥ڥɤ */
	if ( mknl_run_mtcb != NULL )
	{
		ctxinf = &mknl_run_mtcb->ctxinf;
	}
	else
	{
		ctxinf = &mknl_idlctx;
	}
	SuspendThread(ctxinf->hThread);
	ctxinf->blIntSuspend = TRUE;

	/* ߥե饰å */
	hospac_blInt = TRUE;

	/* 󥿥(ߥƥȤ˰ܹ) */
	mknl_sta_ind();
	
	/* ߤμ¹ */
	if ( kernel_intcb_tbl[intno].isr != NULL )
	{
		kernel_intcb_tbl[intno].isr(kernel_intcb_tbl[intno].exinf);			/* ߥӥ롼¹ */
	}

	/* ˰ܹ */
	mknl_ext_ind();

	/* ߥե饰ꥢ */
	hospac_blInt = FALSE;

	/* ٱե饰ꥢ */
	mknl_ctx_stat = MKNL_TSS_TSK;

	/* ǹͥ٤μ¹Բǽõ */
	mknl_run_mtcb = mknl_srh_top();
	if ( mknl_run_mtcb != NULL )
	{
		ctxinf = &mknl_run_mtcb->ctxinf;
	}
	else
	{
		ctxinf = &mknl_idlctx;
	}

	/* ޥեֵ */
	if ( ctxinf->blIntSuspend )
	{
		ctxinf->blIntSuspend = FALSE;
		ReleaseSemaphore(hospac_hSem, 1, NULL);
	}

	/* ¹楹åɤ */
	ResumeThread(ctxinf->hThread);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
