/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*   ץåݲݡͥ (SH)  ߥޥ              */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* Хѿ */
UW hospac_sh_imsk      = 0;		/* ߥޥ */
UW hospac_sh_imsk_base = 0;		/* ߥޥ١ */



/* ߥޥ */
ER chg_imsk(IMSK imsk)
{
	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR
	if ( imsk < 0 || imsk > 15 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();		/* ƥΥå */
	
	hospac_sh_imsk_base = (imsk << 4);
	if ( mknl_sns_ctx() || hospac_sh_imsk < hospac_sh_imsk_base )
	{
		hospac_sh_imsk = hospac_sh_imsk_base;
	}
	
	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ߥޥλ */
ER get_imsk(IMSK *p_imsk)
{
	*p_imsk = hospac_sh_imsk_base >> 4;
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
