/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ °Ʊǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* Ԥ֤ζƳ */
ER frsm_tsk(
		ID tskid)	/* ƳоݤΥIDֹ */
{
		T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ֥Ⱦ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( !(mknl_get_tskstat(&tcb_ram->mtcb) & TTS_SUS) )
	{
		/* Ԥ֤Ǥʤ */
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ֥Ȥξ */
	}
#endif

	/* ζԤ */
	tcb_ram->suscnt = 0;
	mknl_rsm_tsk(&tcb_ram->mtcb);
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}			


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
