/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* νλ */
void ext_tsk(void)
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM *tcb_ram;
	T_MKNL_TCB *mtcb_run;

	/* ¹楿μ */
	mtcb_run = mknl_get_run_tsk();

	mknl_loc_sys();	/* ƥΥå */

	/* ¹ԥνλ */
	mknl_ter_tsk(mtcb_run);

	tcb_ram = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb_run);
	tcb_rom = tcb_ram->tcb_rom;

	/* ư塼󥰤Ƥʤ */
	if ( tcb_ram->actcnt > 0 )
	{
		tcb_ram->actcnt--;	/* 塼󥰸 */

		/* ¹ԥƥϿ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				tcb_rom->exinf,			/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
		tcb_ram->suscnt = 0;	/* Ԥͥȥꥢ */
		tcb_ram->wupcnt = 0;	/* Ԥ׵ᥭ塼󥰥ꥢ */
	}

	/* ǥѥåμ¹ */
	mknl_exe_dsp();
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
