/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ޥե                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"
#include "knl_sys.h"



/* ޥեξֻ */
ER ref_sem(
		ID     semid,		/* ֻоݤΥޥեIDֹ */
		T_RSEM *pk_rsem)	/* ޥե֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_SEMCB_RAM *semcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif

	/* ѥ᡼Υå */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rsem == NULL )
	{
		return E_PAR;	/* ѥ᡼顼 */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ޥեԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&semcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rsem->wtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rsem->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* ޥեθߤλ񸻿 */
	pk_rsem->semcnt = semcb_ram->semcnt;

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
