/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ޥե                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* ޥե(IDֹ漫ưդ) */
ER_ID acre_sem(
		const T_CSEM *pk_csem)	/* ޥե줿ѥåȤؤΥݥ */
{
	ID semid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ѲǽIDθ */
	for ( semid = KERNEL_TMAX_SEMID; semid >= KERNEL_TMIN_SEMID; semid-- )
	{
		if ( KERNEL_SEMID_TO_SEMCB_RAM(semid) == NULL )
		{
			break;
		}
	}
	
	/* IDֹ­å */
#ifdef HOS_ERCHK_E_NOID
	if ( semid < KERNEL_TMIN_SEMID )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOID;	/* IDֹ­ */
	}
#endif

	/* ޥե */
	ercd = kernel_cre_sem(semid, pk_csem);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* ƥΥå */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* ƥΥå */

	return (ER_ID)semid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
