/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Ĺ֥åγ(ݡ) */
ER pget_mpf(
		ID mpfid,		/* ֥åоݤθĹסIDֹ */
		VP *p_blk)		/* ֥åƬ */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	if ( mpfcb_ram->free != NULL )
	{
		/* ֥åгƤ */
		*p_blk          = mpfcb_ram->free;
		mpfcb_ram->free = *(VP *)mpfcb_ram->free;	/* ζꥢ */
		ercd = E_OK;
	}
	else
	{
		/* ֥å̵Хॢ */
		ercd = E_TMOUT;
	}

	mknl_unl_sys();		/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
