/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå åХåե                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "knl_sys.h"


/* åХåեξֻ */
ER ref_mbf(
		ID     mbfid,		/* ּоݤΥåХåեIDֹ */
		T_RMBF *pk_rmbf)	/* åХåե֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_MBFCB_RAM *mbfcb_ram;
	T_MKNL_TCB         *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* ID */
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rmbf == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* åХåեԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&mbfcb_ram->sndque);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rmbf->stskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rmbf->stskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* åХåեμԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&mbfcb_ram->rcvque);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rmbf->rtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rmbf->rtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* åХåեäƤåμ*/
	pk_rmbf->smsgcnt = mbfcb_ram->smsgcnt;
	
	/* åХåեΰζΰΥμ */
	pk_rmbf->fmbfsz = mbfcb_ram->fmbfsz;
	if ( pk_rmbf->fmbfsz > sizeof(UINT) )
	{
		pk_rmbf->fmbfsz -= sizeof(UINT);
	}
	else
	{
		pk_rmbf->fmbfsz = 0;
	}

	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
