/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* ٥ȥե饰Υå */
ER set_flg(
		ID     flgid,		/* åоݤΥ٥ȥե饰IDֹ */
		FLGPTN setptn)		/* åȤӥåȥѥ */
{
	const T_KERNEL_FLGCB_ROM *flgcb_rom;
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_KERNEL_FLGINF          *pk_flginf;
	T_MKNL_TCB *mtcb;
	T_MKNL_TCB *mtcb_next;
	BOOL       wupflg = FALSE;	/* ưե饰 */

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif

	flgcb_rom = flgcb_ram->flgcb_rom;

	/* ե饰Υå */
	flgcb_ram->flgptn = (FLGPTN)(flgcb_ram->flgptn | setptn);

	/* Ԥеå */
	mtcb = mknl_ref_qhd(&flgcb_ram->que);
	while ( mtcb != NULL )
	{
		mtcb_next = mknl_ref_nxt(&flgcb_ram->que, mtcb);	/* Ԥ */
		
		/* ե饰å */
		pk_flginf = (T_KERNEL_FLGINF *)mtcb->data;
		if ( kernel_chk_flg(flgcb_ram, pk_flginf) )
		{
			/* Ƥʤ */
			pk_flginf->waiptn = flgcb_ram->flgptn;	/* ߤΥե饰ѥǼ */
			if ( flgcb_rom->flgatr & TA_CLR )
			{
				flgcb_ram->flgptn = 0;				/* ꥢ°Хꥢ */
			}

			/* Ԥ */
			mknl_rmv_que(mtcb);			/* Ԥ󤫤鳰 */
			mknl_rmv_tmout(mtcb);		/* ॢȲ */
			mknl_wup_tsk(mtcb, E_OK);	/* Ԥε */
			wupflg = TRUE;
		}
		mtcb = mtcb_next;	/* Υ˿ʤ */
	}

	/* ưԤäʤǥѥåԤ */
	if ( wupflg )
	{
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}
	
	mknl_unl_sys();	/* ƥΥå */
	
	return E_OK;	/* ｪλ */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
