/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǡ塼                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* ǡ塼ؤ(ॢȤ) */
ER      tsnd_dtq(
		ID     dtqid,	/* оݤΥǡ塼IDֹ */
		VP_INT data,	/* ǡ塼ǡ */
		TMO    tmout)	/* ॢȻ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;
	UINT tail;
	ER   ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if (  tmout != TMO_POL && mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	if ( mknl_ref_qhd(&dtqcb_ram->rcvque) != NULL )
	{
		/* Ԥг */
		mtcb = mknl_ref_qhd(&dtqcb_ram->rcvque);	/* ԤƬ饿Ф */
		mknl_rmv_que(mtcb);							/* Ԥ󤫤 */
		mknl_rmv_tmout(mtcb);						/* ॢȲ */
		mtcb->data = data;							/* ǡǼ */
		mknl_wup_tsk(mtcb, E_OK);					/* Ԥ */
		
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
		
		ercd = E_OK;
	}
	else
	{
		/* Ԥ̵Хǡ塼˳Ǽ */
		dtqcb_rom = dtqcb_ram->dtqcb_rom;
		if ( dtqcb_ram->datacnt >= dtqcb_rom->dtqcnt )
		{
			/* ǡ塼դʤ */
			if ( tmout == TMO_POL )
			{
				/* ݡ󥰤ʤ¨ॢ */
				ercd = E_TMOUT;
			}
			else
			{
				/* Ԥ */
				mtcb = mknl_get_run_tsk();		/* ߤΥ */
				mtcb->data = data;				/* ǡ¸ */
				mknl_wai_tsk(mtcb, TTW_SDTQ);	/* Ԥ֤ */
				mknl_add_que(&dtqcb_ram->sndque, mtcb, dtqcb_rom->dtqatr);	/* Ԥɲ */
				
				/* ̵ԤǤʤ */
				if ( tmout != TMO_FEVR )
				{
					mknl_add_tmout(mtcb, (RELTIM)tmout);	/* ॢȥ塼ɲ */
				}
				
				ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
				mknl_exe_tex();				/* 㳰μ¹ */
			}
		}
		else
		{
			/* ǡ塼˥ǡǼ */
			tail = dtqcb_ram->head + dtqcb_ram->datacnt;
			if ( tail >= dtqcb_rom->dtqcnt )
			{
				tail -= dtqcb_rom->dtqcnt;
			}
			dtqcb_rom->dtq[tail] = data;
			dtqcb_ram->datacnt++;
			
			ercd = E_OK;
		}
	}

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
