/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǡ塼                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* ǡ塼ؤζ */
ER fsnd_dtq(
		ID     dtqid,	/* оݤΥǡ塼IDֹ */
		VP_INT data)	/* ǡ塼ǡ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;
	UINT tail;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	if ( mknl_ref_qhd(&dtqcb_ram->rcvque) != NULL )
	{
		/* Ԥг */
		mtcb = mknl_ref_qhd(&dtqcb_ram->rcvque);	/* ԤƬ饿Ф */
		mknl_rmv_que(mtcb);							/* Ԥ󤫤 */
		mknl_rmv_tmout(mtcb);						/* ॢȲ */
		mtcb->data = data;							/* ǡǼ */
		mknl_wup_tsk(mtcb, E_OK);					/* Ԥ */
		
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}
	else
	{
		/* Ԥ̵Хǡ塼˳Ǽ */
		dtqcb_rom = dtqcb_ram->dtqcb_rom;
		if ( dtqcb_ram->datacnt >= dtqcb_rom->dtqcnt )
		{
			/* ǡ塼ǧ */
#ifdef HOS_ERCHK_E_ILUSE
			if ( dtqcb_rom->dtqcnt == 0 )
			{
				mknl_unl_sys();	/* ƥΥå */
				return E_ILUSE;	/* ӥ */
			}
#endif

			/* 塼ƬΥǡä */
			dtqcb_rom->dtq[dtqcb_ram->head] = data;
			dtqcb_ram->head++;
			if ( dtqcb_ram->head >= dtqcb_rom->dtqcnt )
			{
				dtqcb_ram->head -= dtqcb_rom->dtqcnt;
			}
		}
		else
		{
			/* ǡ塼˥ǡǼ */
			tail = dtqcb_ram->head + dtqcb_ram->datacnt;
			if ( tail >= dtqcb_rom->dtqcnt )
			{
				tail -= dtqcb_rom->dtqcnt;
			}
			dtqcb_rom->dtq[tail] = data;
			dtqcb_ram->datacnt++;
		}
	}

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
