<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_XeblogCategory
/**
 *	XanhteץꥱΥȥåХå饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_XeblogTrackbackManager extends Xanhte_AppManager
{
	function Xanhte_XeblogTrackbackManager(&$backend){
		$this->Xanhte_AppManager(&$backend);
	}
	
	/**
	 *	XanhteץꥱΥȥåХå饹
	 *
	 *	@access		public
	 *	@param      object Xanhte_XeblogEntry
	 */
	
	function _doTrackback($entry){
		global $xoopsModule ;

		$blog_id = $entry->get('blog_id');
		$xeblog_tb =& new Xanhte_XeblogTrackback(&$this->backend);
		$xeblog_tb->set('blog_id', $blog_id);
		$xeblog_tb->set('direction', 'transmit');
		$xeblog_tb->set('trackback_created', time());
		// ȥåХåURL
		$tb_urls = explode("\n", $this->af->get('trackbackurl'));
		$tb_success_urls = '' ;
		$result_msg = '';
		foreach($tb_urls as $tb_url){
			$tb_url = trim($tb_url);
			if(!$tb_url) continue;
			if(preg_match('|^https?://[\w\-]+\.[\w\-]+|', $tb_url)){
				$xeblog_tb->set('tb_url',$tb_url);
				$xeblog_tb->setUp4Send($entry);
				// ΥȥåХåURLblog_idȤ߹碌ǤƤʤå
				if($xeblog_tb->checkSended()){
					// 
					if( $xeblog_tb->TrackbackSend($tb_url) === true ){
						// ȥåХåΥǡ줿
						$xml_data = $xeblog_tb->getTrackbackTransmittedData();
						// Υ
						$xeblog_tb->set('link', $xml_data['link']);
						$xeblog_tb->set('title', $xml_data['title']);
						$xeblog_tb->set('description', $xml_data['description']);
						$xeblog_tb->add();
						$result_msg .= $tb_url . "=&gt;" . "success<br />\n" ;
					}else{
						$result_msg .= $tb_url . "=&gt;" . "failed<br />\n" ;
					}
				}
			}else{
				$result_msg .= $tb_url . "=&gt;" . "is not valid URL<br />\n" ;			
			}
		}
		if($result_msg){
			$result_msg =  "<br />\n---- &nbsp; Trackback &nbsp; ----\n<br />\n" . $result_msg . "<br />" ;
		}
		return $result_msg ;
	}

	
		
	/**
	 * ȥåХåκ()
	 * POST줿trackbackURLȡblog_idȥåХå
	 * @return arraytrackbackURL
	 **/
	function diff_and_delete_NowTBPastTB(){
		// ȥåХåκƻӤƥȥåХåURLäƤ
		// ƤTB
		$blog_id = $this->af->get('blog_id');
		$nowTrackbackURL = array();
		foreach(explode("\n",trim($this->af->get('trackbackurl'))) as $key=>$value){
			if(trim($value)){
				$nowTrackbackURL[] = trim($value);
			}
		}
		// ƺѤߤTB
		$postedTrackbackURL = $this->getPostedTrackbackURL($blog_id) ;
		// ӡ
		$deleted_tb = array();
		$dummy_prop = array('direction'=>'transmit', 'blog_id'=>$blog_id, 'description'=>'', 'link'=>'', 'title'=>'', 'blog_name'=>'', 'trackback_created'=>'');
		foreach($postedTrackbackURL as $postedTBurl){
			if(empty($postedTBurl)) continue ;
			if(!in_array($postedTBurl, $nowTrackbackURL)){
				$dummy_prop['tb_url'] = $postedTBurl ;
				$delete_tb =& new Xanhte_XeblogTrackback(&$this->backend, null, null, $dummy_prop);
				$delete_tb->remove();
				$deleted_tb[] = $postedTBurl ;
			}
		}
		return $deleted_tb ;
	}
	

	/**
	 * ȥåХåκ()
	 * POST줿trackbackURLȡblog_idȥåХå
	 * @return arraytrackbackURL
	 **/
	function deleteRecievedTrackback(){
		$targetTB = $this->af->get('trackbackurl_del');
		if(!$targetTB){
			return null ;
		}
		$prop_def = array('blog_id', 'tb_url', 'direction');
		$ret = array();
		foreach($targetTB as $tb_url){
			$prop = array($this->af->get('blog_id'), $tb_url, 'recieved');
			$tb = new Xanhte_XeblogTrackback(&$this->backend, $prop_def, $prop);
			if( $tb->remove() === 0 ){
				$ret[] = $tb_url ;
			}
		}
	}
	
	
	
	
	// ȥåХå
	// @access public
	// @param int blog_id
	// @param int direction 1=transmit 0=recieved
	// @return array
	function getTrackbackByBlogid($blog_id, $direction=0){
		$direction = $direction==1 ? 'transmit' : 'recieved' ; 
		$filter = array(
			'blog_id' => new Ethna_AppSearchObject($blog_id, OBJECT_CONDITION_EQ),
			'trackback_created' => new Ethna_AppSearchObject(0, OBJECT_CONDITION_GT),
			'direction' => new Ethna_AppSearchObject($direction, OBJECT_CONDITION_EQ),
			'tb_url' => new Ethna_AppSearchObject('http://', OBJECT_CONDITION_LIKE),			
		);
		$posted_tb = $this->getObjectPropList('XeblogTrackback', null, $filter, array('trackback_created'=>OBJECT_SORT_DESC) );

		return $posted_tb[1] ;
	
	}
	
	// TrackbackURL֤
	// @access public
	// @param int blog_id
	// @return array array('http://...','http;//...',)
	function getPostedTrackbackURL($blog_id){
		$tb_url = array();
		$tb_array = $this->getTrackbackByBlogid($blog_id, 1);
		foreach($tb_array as $tb){
			$tb_url[] = $tb['tb_url'];
		}
		return $tb_url ;
	}
	
	/**
	 * Trackback֤
	 * @param int blog_id
	 * @return array trackback
	 **/
	function getRecievedTrackback($blog_id){
		$recieved_tb = array();
		$tb_array = $this->getTrackbackByBlogid($blog_id, 0);
		return $tb_array ;
	}
	 
	// @access public
	// @param int ưΨ
	// ޤätrackback keyäǥեȤ10%γǵư
	function garbageTrackbackKey($per=10){
		global $xoopsDB, $xoopsModule;
		if(rand(0,100) >  $per){
			return null ;
		}
		// SQL
		$sql = sprintf('delete from %s where tb_url=tbkey and trackback_created<%d',
					   $xoopsDB->prefix($xoopsModule->dirname().'_trackback'), time()-86400 ); // 
		$xoopsDB->query($sql);
	}
	 
	/**
	 * XMLå֤
	 * @param boolean ξtrue
	 */
	function returnXML($is_success=true){
		require_once 'Services/Trackback.php';
		$data = array('id'=>1); // dummy
		$tb =& Services_Trackback::create($data);
		if($is_success){
			$message = 'Trackback success' ;
			$code = 0 ;
		}else{
			$message = 'invalid trackback data';
			$code = 1 ;
		}
		$xml = $tb->getResponseError($message, $code);
		
		return $xml ;
	}
}
// }}}

// {{{ Xanhte_Category
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */
class Xanhte_XeblogTrackback extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
	var $table_def = array(
			'xeblog_trackback' => array(
				'primary' => true 
				)
			);
	
	var $prop_def = array(
		'blog_id'=> array(
			'primary' => true,
			'key' => true,
			'seq' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'blog_id',
			'prop_name' => 'ȥID' ,
			),
		'tb_url'=> array(
			'primary' => true,
			'key' => true,
			'seq' => false,			
			'type' => VAR_TYPE_STRING,
			'form_name' => 'tb_url',
			'prop_name' => 'ȥåХåURL' ,
		),
		'blog_name'=> array(  // 
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'blog_name',
			'prop_name' => '֥̾' , 
		),
	    'title'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'title',
			'prop_name' => 'ȥ꥿ȥ' ,
		),
	    'description'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'description',
			'prop_name' => 'ȥåХå' ,
		),
		'link'=> array(  // 
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'cat_imgurl',
			'prop_name' => 'URL' ,
		),
		'direction'=> array(
			'primary' => true,
			'key' => false,
			'seq' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'direction',
			'prop_name' => '' ,
		),
		'trackback_created'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'trackback_created',
			'prop_name' => '' ,
		),
		'tbkey'=> array(
			'primary' => false,
			'key' => false,
			'seq' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'tbkey',
			'prop_name' => 'ѥɻߥ' ,
		),
		
		);

	/**#@-*/	    
	// åŪΥץѥƥ
	// @access private
	var $trackback=null ;  // Services_Trackback֥
	
	var $http_req=null ; // HTTP_Request ֥

	var $unserializer=null ; // XML_Unserializer ֥

	var $trackbackedURL=array(); // Ƥ줿TrackbackURL array($blog_id=>array('http://..','http://',..)) Ȥcache
	
	/**#@-*/

	/**
	 *	Xeblog_Trackback饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_XeblogTrackback(&$backend, $key_type = null, $key = null, $prop = null)
	{
	    $r = $this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    if (Ethna::isError($r)) {
			return $r;
	    }
		// ֥ȼԤϤ˵Ҥޤ
	}

	
	// Services_Trackback֥Ȥäƥåȥåפѡ
	// @param $entry :: Xanhte_XeblogEntry֥
	// @access public
	function setUp4Send($entry){
		global $xoopsModule ;
		require_once 'Services/Trackback.php';

		if(is_null($this->trackback)){
			// ȥåХåѤΥ֥Ȥ
			$myts =& MyTextSanitizer::getInstance();
			$contents = $entry->get('contents');
			$contents = strip_tags($myts->displayTarea($contents)) ;
			$entry_data = array(
				'id' => 1, // ΤɬפʤΤ褯ʬʤ
				'title' => Xanhte_Util::con_enc($entry->get('title'), 'UTF-8'),
				'excerpt' => Xanhte_Util::con_enc($contents, 'UTF-8'),
				'blog_name' => Xanhte_Util::con_enc($entry->getBlogName(), 'UTF-8'),
				'url' => sprintf('%s/modules/%s/?action_xeblog_details=1&blog_id=%d', XOOPS_URL, $xoopsModule->dirname(), $entry->get('blog_id') ),
				'trackback_url' => '', // 
				);
			$options = array(
				'httpRequest' => array(
					'useragent' => 'XOOPS module/Xeblog trackback',
				)
			);
			$this->trackback =& Services_Trackback::create($entry_data, $options);
		}
		
		return null ;
	}

	// ǤѤߤTrackbackURLǤʤå
	// @access public
	function checkSended(){
		if(! preg_match('|^http://\w+\.\w+|', $this->get('tb_url')) ){
			return false ;
		}
		// Trackback
		$blog_id = $this->get('blog_id');
		$postedTrackbackURL = $this->xeblogT->getPostedTrackbackURL($blog_id);

		// 
		if(in_array(trim($this->get('tb_url')), $postedTrackbackURL)){
			return false ;
		}else{
			return true ;
		}
	}
	
	// ȥåХå
	// @param $tb_url : ȥåХåURL
	// @access public
	function TrackbackSend($tb_url){

		if(is_null($this->trackback)){
			return PEAR::raiseError('Setup trackback object for send.');
		}
		// Trackback
		$this->trackback->set('trackback_url', $tb_url) ;
		$res = $this->trackback->send();
		return $res ;
	}
	
	// ȥåХåURL__mode=rssդƥȥǡ
	
	function getTrackbackTransmittedData(){
	// @access public
		$tb_url = $this->trackback->get('trackback_url');
		$tb_url .= preg_match('/\?/', $tb_url) ? '&__mode=rss' : '?__mode=rss' ; 

		if(is_null($this->http_req)){
			$this->http_req =& new HTTP_Request ;
			$this->http_req->setMethod(HTTP_REQUEST_METHOD_GET);
		}
		$this->http_req->setURL($tb_url) ;
		$response = $this->http_req->sendRequest() ;
		if (PEAR::isError($response) || $this->http_req->getResponseCode() != 200) {
            return null;
        }
		
		// XML
		$xml = $this->http_req->getResponseBody();
		$xmldata = $this->_parseTrackBackXML($xml) ;
		return $xmldata ;
	
	}
	
	
	// @access private
	function _parseTrackBackXML($xml){
		// Unserialize֥
		if(is_null($this->unserializer)){
			require_once 'XML/Unserializer.php';
			$this->unserializer = & new XML_Unserializer();
		}
		
		$encoding = '';
		$data = array('title'=>'', 'link'=>'', 'description'=>'' );
		if( trim($xml) ){
			foreach( explode( "\n" , $xml ) as $xml_line){
				if( preg_match( "/<\?xml.+encoding=[\"\']+([^\"]+)[\"\']+\?>/i" , $xml_line ,$match) )
					$encoding = strtoupper( $match[1] ) ;
				break ;
			}
			if( empty( $encoding )&& function_exists('mb_detect_encoding') ){
				$encoding = mb_detect_encoding($xml) ;
			}
			if( $status = $this->unserializer->unserialize($xml) ){
				$unserialize_data = $this->unserializer->getUnserializedData() ;
				if(isset($unserialize_data['rss'])){
					$data['title'] = $unserialize_data['rss']['channel']['title']  ;
					$data['description'] = $unserialize_data['rss']['channel']['description']  ;
					$data['link'] = $unserialize_data['rss']['channel']['link']  ;
				}else{
					$data = array('title'=>'', 'description'=>'', 'link'=>'');
				}
			}
		}
		$data = Xanhte_Util::con_enc($data, _CHARSET, $encoding);
		return $data ;
	}
	
}
// }}}

?>
