package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.ws.xcloud.AddEBSStorageRequest;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateStorageDialog.DialogData;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;

public class CreateStorageHandler implements ICloudOptionHandler, CloudStringConstants, AWSStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		final ILocation location = (ILocation)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveLocation);
		
		final AddEBSStorageRequest request = new AddEBSStorageRequest();
		CreateStorageDialog dialog = new CreateStorageDialog(
				HandlerUtil.getActiveShell(event),
				location,
				MessageFormat.format(dlgStorageCreate, strAws),
				new AWSResourceProvider(location));
		
		dialog.setDialogDataFactory(
			new CreateStorageDialog.DialogDataFactory() {
				@Override
				public DialogData createDialogData() {
					return new DialogData() {
						@Override
						public String getName() {
							return request.getStorageName();
						}
						@Override
						public void setName(String value) {
							request.setStorageName(value);
						}
						@Override
						public Integer getIops() {
							return request.getIops();
						}
						@Override
						public void setIops(Integer value) {
							request.setIops(value);
						}
						@Override
						public Integer getSize() {
							return request.getSize();
						}
						@Override
						public void setSize(Integer value) {
							request.setSize(value);
						}
						@Override
						public String getType() {
							return request.getStorageType();
						}
						@Override
						public void setType(String value) {
							request.setStorageType(value);
						}
						@Override
						public String getAvailabilityZone() {
							return request.getZone();
						}
						@Override
						public void setAvailabilityZone(String availabilityZone) {
							request.setZone(availabilityZone);
						}
						@Override
						public String getSnapshotId() {
							return request.getSnapshotId();
						}
						@Override
						public void setSnapshotId(String value) {
							request.setSnapshotId(value);
						}
					};
				}
			});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmhStorageCreate, request.getStorageName()))) {
				
				try {
					AWSOptionEndpoint endpoint = location.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
					endpoint.addEBSStorage(location.getCloudScope().getId(), location.getId(), request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishStorageCreate, request.getStorageName()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							location.getComputeResources().updateStorages();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
