package com.clustercontrol.xcloud.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.xcloud.AutoAssigneNodePatternEntry;
import com.clustercontrol.ws.xcloud.AutoAssigneNodePatternEntryType;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.util.HinemosUtil;

public class AutoAssignNodeRuleEditDialog extends Dialog implements CloudStringConstants {
	public static final long serialVersionUID = 1L;
	
	private String managerName;
	private List<AutoAssigneNodePatternEntry> entries = new ArrayList<>();
	private List<AutoAssigneNodePatternEntry> completed = new ArrayList<>();
	
	private Table table;
	private Button btnNewButton_2;
	private Button btnNewButton_3;
	private Button button_1;
	
	private static final Map<AutoAssigneNodePatternEntryType, String> patternTypes = new HashMap<AutoAssigneNodePatternEntryType, String>() {
		private static final long serialVersionUID = 1L;{
			put(AutoAssigneNodePatternEntryType.INSTANCE_NAME, strComputeName);
			put(AutoAssigneNodePatternEntryType.CIDR, strIpAddress);
		}};
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AutoAssignNodeRuleEditDialog(Shell parentShell, String managerName) {
		super(parentShell);
		this.managerName = managerName;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.marginBottom = 10;
		gl_container.marginTop = 10;
		gl_container.marginRight = 10;
		gl_container.marginLeft = 10;
		container.setLayout(gl_container);
		
		final TableViewer tableViewer = new TableViewer(container, SWT.BORDER | SWT.FULL_SELECTION);
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				if (!tableViewer.getSelection().isEmpty())
					updateButton();
			}
		});
		table = tableViewer.getTable();
		table.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				if (e.count != 2) {
					Point p =new Point(e.x, e.y);
					ViewerCell cell = tableViewer.getCell(p);
					if (cell != null && cell.getColumnIndex() == 3) {
						ScopeTreeDialog dialog = new ScopeTreeDialog(AutoAssignNodeRuleEditDialog.this.getShell(), managerName, "ADMINISTRATORS", true, false);
						p = AutoAssignNodeRuleEditDialog.this.getShell().toDisplay(p);
						dialog.create();
						dialog.getShell().setLocation(p.x, p.y);
						if (dialog.open() == IDialogConstants.OK_ID) {
							FacilityTreeItem item = dialog.getSelectItem();
							((AutoAssigneNodePatternEntry)cell.getElement()).setScopeId(item.getData().getFacilityId());
							tableViewer.refresh();
							valid();
						}
					}
				}
			}
		});
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 3);
		gd_table.heightHint = 233;
		table.setLayoutData(gd_table);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tblclmnNewColumn.setWidth(50);
		tblclmnNewColumn.setText(strPriority);
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {return Integer.toString(entries.indexOf(element) + 1);}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tblclmnNewColumn_1.setWidth(100);
		tblclmnNewColumn_1.setText(strEvaluteItem);
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				AutoAssigneNodePatternEntry entry = (AutoAssigneNodePatternEntry)element;
				String typeName = patternTypes.get(entry.getPatternType());
				return typeName != null ? typeName: entry.getPatternType().name();
			}
		});
		tableViewerColumn_1.setEditingSupport(new EditingSupport(tableViewer) {
			String[] items = new String[]{patternTypes.get(AutoAssigneNodePatternEntryType.INSTANCE_NAME), patternTypes.get(AutoAssigneNodePatternEntryType.CIDR)};
			@Override protected boolean canEdit(Object element) {return true;}
			@Override protected CellEditor getCellEditor(Object element) {
				return new ComboBoxCellEditor((Table)getViewer().getControl(), items);
			}
			@Override protected Object getValue(Object element) {
				AutoAssigneNodePatternEntry entry = (AutoAssigneNodePatternEntry)element;
				for (int i = 0; i < items.length; ++i) {
					if (patternTypes.get(entry.getPatternType()).equals(items[i]))
						return i;
				}
				return -1;
			}
			@Override
			protected void setValue(Object element, Object value) {
				int index = Integer.valueOf(value.toString());
				if (0 > index || index >= items.length)
					return;
				String selected = items[index];
				for (Map.Entry<AutoAssigneNodePatternEntryType, String> entry: patternTypes.entrySet()) {
					if (entry.getValue().equals(selected)) {
						((AutoAssigneNodePatternEntry)element).setPatternType(entry.getKey());
						getViewer().refresh();
						break;
					}
				}
				valid();
			}
		});
		
		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tblclmnNewColumn_2.setWidth(150);
		tblclmnNewColumn_2.setText(strMatchingCondition);
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {return ((AutoAssigneNodePatternEntry)element).getPattern();}
			@Override public Color getBackground(Object element) {
				AutoAssigneNodePatternEntry entry = (AutoAssigneNodePatternEntry)element;
				return entry.getPattern() == null || entry.getPattern().isEmpty() ? RequiredFieldColorConstant.COLOR_REQUIRED: null;
			}
		});
		tableViewerColumn_2.setEditingSupport(new EditingSupport(tableViewer) {
			@Override protected boolean canEdit(Object element) {return true;}
			@Override protected CellEditor getCellEditor(Object element) {
				return new TextCellEditor((Table)getViewer().getControl());
			}
			@Override protected Object getValue(Object element) {return ((AutoAssigneNodePatternEntry)element).getPattern();}
			@Override protected void setValue(Object element, Object value) {((AutoAssigneNodePatternEntry)element).setPattern(value.toString());getViewer().refresh();valid();}
		});
		
		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tblclmnNewColumn_3.setWidth(150);
		tblclmnNewColumn_3.setText(strScope);
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				AutoAssigneNodePatternEntry entry = (AutoAssigneNodePatternEntry)element;
				return entry.getScopeId() == null || entry.getScopeId().isEmpty() ? "": HinemosUtil.getFacilityPath(managerName, entry.getScopeId());
			}
			@Override public Color getBackground(Object element) {
				AutoAssigneNodePatternEntry entry = (AutoAssigneNodePatternEntry)element;
				return entry.getScopeId() == null || entry.getScopeId().isEmpty() ? RequiredFieldColorConstant.COLOR_REQUIRED: null;
			}
		});
		
		tableViewer.setContentProvider(new ArrayContentProvider());
		tableViewer.setInput(entries);

		btnNewButton_2 = new Button(container, SWT.NONE);
		btnNewButton_2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
				if (!selection.isEmpty()) {
					int index = entries.indexOf(selection.getFirstElement());
					if (index != 0) {
						entries.remove(selection.getFirstElement());
						entries.add(index - 1, (AutoAssigneNodePatternEntry)selection.getFirstElement());
						tableViewer.refresh();
						tableViewer.setSelection(new StructuredSelection(selection.getFirstElement()));
					}
				}
				updateButton();
			}
		});
		
		GridData gd_btnNewButton_2 = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnNewButton_2.widthHint = 30;
		btnNewButton_2.setLayoutData(gd_btnNewButton_2);
		btnNewButton_2.setText(strArrowUp);
		btnNewButton_2.setEnabled(false);
		
		btnNewButton_3 = new Button(container, SWT.NONE);
		btnNewButton_3.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
				if (!selection.isEmpty()) {
					int index = entries.indexOf(selection.getFirstElement());
					if (index != entries.size() - 1) {
						entries.remove(selection.getFirstElement());
						entries.add(index + 1, (AutoAssigneNodePatternEntry)selection.getFirstElement());
						tableViewer.refresh();
						tableViewer.setSelection(new StructuredSelection(selection.getFirstElement()));
					}
				}
				updateButton();
			}
		});
		GridData gd_btnNewButton_3 = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnNewButton_3.widthHint = 30;
		btnNewButton_3.setLayoutData(gd_btnNewButton_3);
		btnNewButton_3.setText(strArrowDown);
		btnNewButton_3.setEnabled(false);
		new Label(container, SWT.NONE);
		
		Composite composite_1 = new Composite(container, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Button button = new Button(composite_1, SWT.NONE);
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				AutoAssigneNodePatternEntry entry = new AutoAssigneNodePatternEntry();
				entry.setPatternType(AutoAssigneNodePatternEntryType.CIDR);
				entry.setPattern("");
				entry.setScopeId("");
				entries.add(entry);
				tableViewer.refresh();
				tableViewer.setSelection(new StructuredSelection(entry));
				updateButton();
				valid();
			}
		});
		button.setText(strAdd);
		button.setBounds(272, 0, 90, 25);
		
		button_1 = new Button(composite_1, SWT.NONE);
		button_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
				if (selection.isEmpty()) {
					updateButton();
					return;
				}
				
				int index = entries.indexOf(selection.getFirstElement());
				entries.remove(selection.getFirstElement());
				tableViewer.refresh();
				if (!entries.isEmpty())
					tableViewer.setSelection(new StructuredSelection(entries.get(Math.min(index, entries.size() - 1))));
				updateButton();
				valid();
			}
		});
		button_1.setText(strDelete);
		button_1.setEnabled(false);
		button_1.setBounds(368, 0, 92, 25);
		
		updateButton();
		return container;
	}
	
	private void updateButton() {
		int index = table.getSelectionIndex();
		if (index != -1) {
			button_1.setEnabled(true);
			if (table.getItemCount() > 1) {
				if (index == 0) {
					btnNewButton_2.setEnabled(false);
					btnNewButton_3.setEnabled(true);
				} else if (index == table.getItemCount() - 1) {
					btnNewButton_2.setEnabled(true);
					btnNewButton_3.setEnabled(false);
				} else {
					btnNewButton_2.setEnabled(true);
					btnNewButton_3.setEnabled(true);
				}
			} else {
				btnNewButton_2.setEnabled(false);
				btnNewButton_3.setEnabled(false);
			}
		} else {
			button_1.setEnabled(false);
			btnNewButton_2.setEnabled(false);
			btnNewButton_3.setEnabled(false);
		}
	}
	
	@Override
	protected Control createContents(Composite parent) {
		Control c = super.createContents(parent);
		valid();
		return c;
	}

	
	private void valid() {
		boolean valid = true;
		for (AutoAssigneNodePatternEntry entry: this.entries) {
			if ((entry.getScopeId() == null || entry.getScopeId().isEmpty()) ||
				entry.getPatternType() == null ||
				(entry.getPattern() == null || entry.getPattern().isEmpty())
				) {
				valid = false;
				break;
			}
		}
		getButton(IDialogConstants.OK_ID).setEnabled(valid);
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}
	
	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(539, 383);
	}
	
	public void setInput(List<AutoAssigneNodePatternEntry> entries) {
		this.entries.clear();
		this.completed.clear();
		for (AutoAssigneNodePatternEntry entry: entries) {
			AutoAssigneNodePatternEntry e = new AutoAssigneNodePatternEntry();
			e.setScopeId(entry.getScopeId());
			e.setPatternType(entry.getPatternType());
			e.setPattern(entry.getPattern());
			this.entries.add(e);
		}
	}
	
	public List<AutoAssigneNodePatternEntry> getOutput() {
		return completed;
	}
	
	@Override
	protected void okPressed() {
		completed.clear();
		for (AutoAssigneNodePatternEntry entry: this.entries) {
			AutoAssigneNodePatternEntry e = new AutoAssigneNodePatternEntry();
			e.setScopeId(entry.getScopeId());
			e.setPatternType(entry.getPatternType());
			e.setPattern(entry.getPattern());
			this.completed.add(e);
		}
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgComputeAssignScopeRule);
	}
}