/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.cloud;

import java.util.List;

import com.clustercontrol.ws.notify.NotifyRelationInfo;
import com.clustercontrol.ws.xcloud.MonitorKind;
import com.clustercontrol.xcloud.model.base.CollectionObserver;
import com.clustercontrol.xcloud.model.base.IElement;
import com.clustercontrol.xcloud.model.base.PropertyId;
import com.clustercontrol.xcloud.model.base.ValueObserver;

public interface IBillingAlarm extends IElement {
	// プロパティの Id
	public interface p {
		static final PropertyId<ValueObserver<String>> description = new PropertyId<ValueObserver<String>>("description"){};
		static final PropertyId<ValueObserver<Long>> regDate = new PropertyId<ValueObserver<Long>>("regDate"){};
		static final PropertyId<ValueObserver<String>> regUser = new PropertyId<ValueObserver<String>>("regUser"){};
		static final PropertyId<ValueObserver<Long>> updateDate = new PropertyId<ValueObserver<Long>>("updateDate"){};
		static final PropertyId<ValueObserver<String>> updateUser = new PropertyId<ValueObserver<String>>("updateUser"){};
		static final PropertyId<ValueObserver<String>> name = new PropertyId<ValueObserver<String>>("name"){};
		static final PropertyId<ValueObserver<String>> facilityId = new PropertyId<ValueObserver<String>>("facilityId"){};
		static final PropertyId<ValueObserver<MonitorKind>> monitorKind = new PropertyId<ValueObserver<MonitorKind>>("monitorKind"){};
		static final PropertyId<ValueObserver<String>> notifyGroupId = new PropertyId<ValueObserver<String>>("notifyGroupId"){};
		static final PropertyId<ValueObserver<String>> ownerRoleId = new PropertyId<ValueObserver<String>>("ownerRoleId"){};
		static final PropertyId<ValueObserver<Double>> thresholdInfoLimit = new PropertyId<ValueObserver<Double>>("thresholdInfoLimit"){};
		static final PropertyId<ValueObserver<Double>> thresholdWarnLimit = new PropertyId<ValueObserver<Double>>("thresholdWarnLimit"){};
		static final PropertyId<ValueObserver<String>> unit = new PropertyId<ValueObserver<String>>("unit"){};
		static final PropertyId<ValueObserver<Boolean>> validFlg = new PropertyId<ValueObserver<Boolean>>("validFlg"){};
		static final PropertyId<ValueObserver<Boolean>> collectFlg = new PropertyId<ValueObserver<Boolean>>("collectFlg"){};
		static final PropertyId<CollectionObserver<NotifyRelationInfo>> notifyRelationInfos = new PropertyId<CollectionObserver<NotifyRelationInfo>>(""){};
	}

	IBillingAlarms getBillingAlarms();

	String getId();
	String getDescription();
	Long getRegDate();
	String getRegUser();
	Long getUpdateDate();
	String getUpdateUser();
	String getName();
	String getFacilityId();
	MonitorKind getMonitorKind();
	String getNotifyGroupId();
	String getOwnerRoleId();
	Double getThresholdInfoLimit();
	Double getThresholdWarnLimit();
	String getUnit();
	Boolean getValidFlg();
	Boolean getCollectFlg();
	List<NotifyRelationInfo> getNotifyRelationInfos();
}