
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>instanceStatusのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="instanceStatus">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="running"/>
 *     &lt;enumeration value="processing"/>
 *     &lt;enumeration value="terminated"/>
 *     &lt;enumeration value="stopped"/>
 *     &lt;enumeration value="unknown"/>
 *     &lt;enumeration value="suspend"/>
 *     &lt;enumeration value="missing"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "instanceStatus")
@XmlEnum
public enum InstanceStatus {

    @XmlEnumValue("running")
    RUNNING("running"),
    @XmlEnumValue("processing")
    PROCESSING("processing"),
    @XmlEnumValue("terminated")
    TERMINATED("terminated"),
    @XmlEnumValue("stopped")
    STOPPED("stopped"),
    @XmlEnumValue("unknown")
    UNKNOWN("unknown"),
    @XmlEnumValue("suspend")
    SUSPEND("suspend"),
    @XmlEnumValue("missing")
    MISSING("missing");
    private final String value;

    InstanceStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static InstanceStatus fromValue(String v) {
        for (InstanceStatus c: InstanceStatus.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
