package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AutoAssigneNodePatternEntry;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;
import com.clustercontrol.xcloud.ui.dialogs.AutoAssignNodeRuleEditDialog;

public class ModifyAutoAssignNodePatternHandler extends AbstractHandler implements CloudStringConstants{
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ICloudScope cloudScope = (ICloudScope)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveCloudScope);
		
		CloudEndpoint endpoint = cloudScope.getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
		try {
			try {
				endpoint.checkCallable(cloudScope.getId(), "registAutoAssigneNodePattern");
			} catch(CloudManagerException e) {
				if ("COMMUNITY_EDITION_FUNC_NOT_AVAILABLE".equals(e.getFaultInfo().getErrorCode())) {
					throw new CloudModelException(CloudConstants.bundle_messages.getString("message.community_edition.func.not_available"));
				}
				throw e;
			}
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
			return null;
		}
		
		List<AutoAssigneNodePatternEntry> entries;
		try {
			entries = endpoint.getAutoAssigneNodePatterns(cloudScope.getId());
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			if (e instanceof CloudManagerException) {
				CloudManagerException cme = (CloudManagerException)e;
				if ("UNSUPPORTED_OPERATION".equals(cme.getFaultInfo().getErrorCode())) {
					message = msgFucUnSupported;
				}
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
			return null;
		}
		
		IWorkbenchPart part = HandlerUtil.getActivePart(event);
		
		AutoAssignNodeRuleEditDialog dialog = new AutoAssignNodeRuleEditDialog(part.getSite().getShell(), cloudScope.getCloudScopes().getHinemosManager().getManagerName());
		dialog.setInput(entries);
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				if (e instanceof CloudManagerException) {
					CloudManagerException cme = (CloudManagerException)e;
					if ("UNSUPPORTED_OPERATION".equals(cme.getFaultInfo().getErrorCode())) {
						message = msgFucUnSupported;
					}
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmModifyAutoAssignNodepattern, cloudScope.getName(), cloudScope.getId()))) {
				
				try {
					endpoint.registAutoAssigneNodePattern(cloudScope.getId(), dialog.getOutput());
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishModifyAutoAssignNodepattern, cloudScope.getName(), cloudScope.getId()));
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					if (e instanceof CloudManagerException) {
						CloudManagerException cme = (CloudManagerException)e;
						if ("UNSUPPORTED_OPERATION".equals(cme.getFaultInfo().getErrorCode())) {
							message = msgFucUnSupported;
						}
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
