package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IBillingAlarm;

public class DeleteBillingAlarmHandler extends AbstractHandler implements CloudStringConstants {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IBillingAlarm billingAlarm = (IBillingAlarm)selection.getFirstElement();
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			MessageFormat.format(msgConfirmDeleteBilligAlarm, billingAlarm.getName(), billingAlarm.getId()))) {
			
			final List<String> alarmIds = new ArrayList<>();
			for (@SuppressWarnings("rawtypes") Iterator iter = selection.iterator(); iter.hasNext();) {
				alarmIds.add(((IBillingAlarm)iter.next()).getId());
			}

			try {
				CloudEndpoint endpoint = billingAlarm.getBillingAlarms().getHinemosManager().getEndpoint(CloudEndpoint.class);
				
				List<String> alaramIds = new ArrayList<>();
				for (@SuppressWarnings("rawtypes") Iterator iter = selection.iterator(); iter.hasNext();) {
					alaramIds.add(((IBillingAlarm)iter.next()).getId());
				}

				endpoint.removeBillingAlarms(alaramIds);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					MessageFormat.format(msgFinishDeleteBilligAlarm, billingAlarm.getName(), billingAlarm.getId()));
				
				Display.getCurrent().asyncExec(new Runnable() {
					@Override
					public void run() {
						billingAlarm.getBillingAlarms().updateBillingAlarms();
					}
				});
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}
		}
		return null;
	}
}