package com.clustercontrol.xcloud.model.cloud;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.xcloud.model.base.Element;
import com.clustercontrol.xcloud.util.CollectionComparator;
import com.clustercontrol.xcloud.util.csv.CSVReader;

public abstract class Resource extends Element implements IResource {
	private List<ExtendedProperty> extendedProperties = new ArrayList<>();
	
	public HinemosManager getHinemosManager() {
		if (getCloudScope() != null && getCloudScope().getCloudScopes() != null)
			return getCloudScope().getCloudScopes().getHinemosManager();
		return null;
	}

	public CloudScope getCloudScope() {
		if (getLocation() != null)
			return getLocation().getCloudScope();
		return null;
	}

	public abstract Location getLocation();
	
	@Override
	public ExtendedProperty[] getExtendedProperties() {
		return extendedProperties.toArray(new ExtendedProperty[extendedProperties.size()]);
	}
	@Override
	public String getExtendedProperty(String name) {
		for (ExtendedProperty property: extendedProperties) {
			if (property.getName().equals(name))
				return property.getValue();
		}
		return null;
	}
	@Override
	public List<String> getExtendedPropertyAsList(String name) {
		String prop = getExtendedProperty(name);
		if (prop == null)
			return Collections.emptyList();
		
		StringReader reader = new StringReader(prop);
		try (CSVReader csvReader = new CSVReader(reader)) {
			return Arrays.asList(csvReader.readNext());
		} catch(IOException e) {
			Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
		}
		return Collections.emptyList();
	}
	
	protected void updateExtendedProperties(List<com.clustercontrol.ws.xcloud.ExtendedProperty> extendedProperties) {
		CollectionComparator.compareCollection(this.extendedProperties, extendedProperties, new CollectionComparator.Comparator<ExtendedProperty, com.clustercontrol.ws.xcloud.ExtendedProperty>(){
			@Override
			public boolean match(ExtendedProperty o1, com.clustercontrol.ws.xcloud.ExtendedProperty o2) {
				return o1.getName().equals(o2.getName());
			}
			@Override
			public void matched(ExtendedProperty o1, com.clustercontrol.ws.xcloud.ExtendedProperty o2) {
				o1.setValue(o2.getValue());
			}
			@Override
			public void afterO1(ExtendedProperty o1) {
				internalRemoveProperty(p.extendedProperties, o1);
			}
			@Override
			public void afterO2(com.clustercontrol.ws.xcloud.ExtendedProperty o2) {
				internalAddProperty(p.extendedProperties, ExtendedProperty.convert(o2));
			}
		});
	}
	
	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") Class adapter) {
		if (adapter == ICloudScope.class) {
			return getCloudScope();
		} else if (adapter == ILocation.class) {
			return getLocation();
		} else if (adapter == IHinemosManager.class) {
			return getHinemosManager();
		}
		return super.getAdapter(adapter);
	}
}
