/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.cloud;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
import com.clustercontrol.xcloud.model.base.Element;
import com.clustercontrol.xcloud.util.CollectionComparator;


public class BillingAlarms extends Element implements IBillingAlarms {
	protected List<BillingAlarm> billingAlarms;
	
	public BillingAlarms(HinemosManager hinemosManager) {
		setOwner(hinemosManager);
	}

	@Override
	public BillingAlarm[] getBillingAlarms() {
		if (billingAlarms == null)
			return new BillingAlarm[]{};
		return billingAlarms.toArray(new BillingAlarm[billingAlarms.size()]);
	}

	@Override
	public BillingAlarm[] getBillingAlarmsWithInitializing() {
		if (billingAlarms == null)
			updateBillingAlarms();
		return billingAlarms.toArray(new BillingAlarm[billingAlarms.size()]);
	}

	@Override
	public BillingAlarm getBillingAlarm(String alarmId) {
		for (BillingAlarm billingAlarm: billingAlarms) {
			if (billingAlarm.getId().equals(alarmId)) {
				return billingAlarm;
			}
		}
		return null;
	}
	
	@Override
	public HinemosManager getHinemosManager() {
		return (HinemosManager)getOwner();
	}
	
	@Override
	public void updateBillingAlarms() {
		if (billingAlarms == null)
			billingAlarms = new ArrayList<>();
		
		CloudEndpoint endpoint = getHinemosManager().getEndpoint(CloudEndpoint.class);
		try {
			List <com.clustercontrol.ws.xcloud.BillingAlarm> webBillingAlarm = endpoint.getAllBillingAlarms();
			CollectionComparator.compareCollection(billingAlarms, webBillingAlarm, new CollectionComparator.Comparator<BillingAlarm, com.clustercontrol.ws.xcloud.BillingAlarm>() {
				public boolean match(BillingAlarm o1, com.clustercontrol.ws.xcloud.BillingAlarm o2) {return o1.equalValues(o2);}
				public void matched(BillingAlarm o1, com.clustercontrol.ws.xcloud.BillingAlarm o2) {o1.update(o2);}
				public void afterO1(BillingAlarm o1) {internalRemoveProperty(p.billingAlarms, o1);}
				public void afterO2(com.clustercontrol.ws.xcloud.BillingAlarm o2) {
					BillingAlarm newBillingAlarm = BillingAlarm.convert(BillingAlarms.this, o2);
					internalAddProperty(p.billingAlarms, newBillingAlarm);
				}
			});
		} catch (CloudManagerException | InvalidRole_Exception | InvalidUserPass_Exception e) {
			Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
		}
	}
}
