package com.clustercontrol.xcloud.extensions;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

import com.clustercontrol.xcloud.Activator;

public class ModelContentProviderExtension {
	private static final String pointId = "modelContentprovider";
	private static final String elementName = "modelContentProvider";
	private static final String providerClassAttributeName = "providerClass";
	private static final String platformIdAttributeName = "platformId";
	
	private Map<String, IModelContentProvider> providerMap = new HashMap<>();
	
	private static ModelContentProviderExtension singleton;
	
	private ModelContentProviderExtension() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();

		// 拡張ポイントを取得
		IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + "." + pointId);
		for (IExtension ex: point.getExtensions()) {
			for (IConfigurationElement element: ex.getConfigurationElements()) {
				// 要素名が該当するpluginInfoのIdだった場合、ExtensionTypeの情報を取得
				if(element.getName().equals(elementName)){
					try {
						String platformId = element.getAttribute(platformIdAttributeName);
						IModelContentProvider provider = (IModelContentProvider)element.createExecutableExtension(providerClassAttributeName);
						
						providerMap.put(platformId, provider);
					} catch (Exception e) {
						Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
					}
				}
			}
		}
	}
	
	public static IModelContentProvider getModelContentProvider(String platformId) {
		if (singleton == null) {
			singleton = new ModelContentProviderExtension();
		}
		return singleton.providerMap.get(platformId);
	}
}