/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointUnit;
import com.clustercontrol.xcloud.model.cloud.HinemosManager;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.util.CollectionComparator;

public class Activator extends AbstractUIPlugin {
	public static String ID = "com.clustercontrol.xcloud.base";

	// The shared instance
	private static Activator plugin;
	private static String pluginPath;

	private Map<EndpointUnit, IHinemosManager> hinemosManagers = new HashMap<>();
	
	public Activator() {
		super();
		plugin = this;
	}

	@Override
	protected void initializeImageRegistry(ImageRegistry registry) {
		registerImage(registry, "user", "user.png");
		registerImage(registry, "account", "account.png");
		registerImage(registry, "aws-box", "aws-box.png");
		registerImage(registry, "checked", "enable.gif");
		registerImage(registry, "unchecked", "disable.gif");
		registerImage(registry, "radio-on", "radio_on.gif");
		registerImage(registry, "radio-off", "radio_off.gif");
		registerImage(registry, "running", "running.png");
		registerImage(registry, "stopped", "stopped.png");
		registerImage(registry, "suspended", "suspended.png");
		registerImage(registry, "changing", "changing.png");
		
		registerImage(registry, "running2", "poweron.png");
		registerImage(registry, "stopped2", "poweroff.png");
		registerImage(registry, "suspended2", "suspend.png");
		registerImage(registry, "terminated", "delete.png");
		registerImage(registry, "processing", "processing.png");
		
		registerImage(registry, "cloudscope", "cloudscope.png");
		registerImage(registry, "location", "location.png");
		registerImage(registry, "instance", "instance.png");
		registerImage(registry, "instance2", "instance2.png");
	}

	private void registerImage(ImageRegistry registry, String key, String fileName) {
		try {
			URL url = new URL(getDefault().getBundle().getEntry("/"), "icons/" + fileName);
			ImageDescriptor desc = ImageDescriptor.createFromURL(url);
			registry.put(key, desc);
		}
		catch (Exception e) {
		}
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	public static String getPluginPath() {
		if (pluginPath == null) {
			// プラグインがインストールされているパスを取得。
			URL entry = Activator.getDefault().getBundle().getEntry("/");
			try {
				String url = FileLocator.resolve(entry).toString();
				// URI クラスは、空白を拒否するので、"%20" へエンコード。
				url = url.replaceAll(" ", "%20");
				pluginPath = new File(new URI(url)).getAbsolutePath();
			}
			catch (Exception e) {
				e.printStackTrace();
				throw new IllegalStateException(e);
			}			
		}

		return pluginPath;
	}
	
	public List<IHinemosManager> getHinemosManagers(){
		List<EndpointUnit> newEndpoints = EndpointManager.getActiveManagerList();
		Set<EndpointUnit> oldEndpoints = hinemosManagers.keySet();
		
		CollectionComparator.compareCollection(newEndpoints, oldEndpoints, new CollectionComparator.Comparator<EndpointUnit, EndpointUnit>() {
			public boolean match(EndpointUnit o1, EndpointUnit o2) {return o1 == o2;}
			public void afterO1(EndpointUnit o1) {hinemosManagers.put(o1, new HinemosManager(o1.getManagerName(), o1.getUrlListStr()));}
			public void afterO2(EndpointUnit o2) {hinemosManagers.remove(o2);}
		});
		
		return new ArrayList<>(hinemosManagers.values());
	}
	
	public IHinemosManager getHinemosManager(String managerName){
		// マネージャ名を直接指定する場合、対象マネージャの存在のみ確認
		for(IHinemosManager manager: getHinemosManagers()){
			if(managerName.equals(manager.getManagerName())){
				return manager;
			}
		}
		return null;
	}
}
