package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CreateInstanceSnapshotRequest;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.CloudOptionExtension;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.ui.dialogs.SnapshotDialog;

public class SnapshotInstanceHandler implements ICloudOptionHandler, CloudStringConstants {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstance instance = (IInstance)selection.getFirstElement();
		
		SnapshotDialog dialog = new SnapshotDialog(HandlerUtil.getActiveShell(event), MessageFormat.format(dlgComputeSnapshot, CloudOptionExtension.getOptions().get(instance.getCloudScope().getCloudPlatform().getId())));
		if (dialog.open() != Window.OK)
			return null;

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			MessageFormat.format(msgConfirmSnapshotCreateComputeNode, instance.getName(), instance.getId()))) {

			try {
				CreateInstanceSnapshotRequest request = new CreateInstanceSnapshotRequest();
				request.setInstanceId(instance.getId());
				request.setName(dialog.getSnapshotName());
				request.setDescription(dialog.getDescription());
				
				CloudEndpoint endpoint = instance.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
				endpoint.snapshotInstance(instance.getCloudScope().getId(), instance.getLocation().getId(), request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					MessageFormat.format(msgFinishSnapshotCreateComputeNode, instance.getName(), instance.getId()));
				
				Display.getCurrent().asyncExec(new Runnable() {
					@Override
					public void run() {
						instance.getBackup().update();
					}
				});
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}
		}
		return null;
	}
}