/*

Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.xcloud.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.xcloud.model.cloud.IBillingAlarm;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.ui.dialogs.BillingAlarmObjectPrivilegeListDialog;

public class ModifyObjectPrivilegeHandler extends AbstractHandler {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		IBillingAlarm billingAlarm = (IBillingAlarm)selection.getFirstElement();
		IHinemosManager manager = (IHinemosManager)billingAlarm.getAdapter(IHinemosManager.class);
		
		BillingAlarmObjectPrivilegeListDialog dialog = new BillingAlarmObjectPrivilegeListDialog(
				HandlerUtil.getActiveShell(event),
				manager.getManagerName(),
				billingAlarm.getId(),
				billingAlarm.getOwnerRoleId()
				);
		dialog.open();
		return null;
	}
}