/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.repository;

import com.clustercontrol.xcloud.model.cloud.HinemosManager;



public class Node extends Facility implements INode {
	private Scope parent;

	@Override
	public Scope getParent() {
		return parent;
	}
	public void setParent(Scope parent) {
		this.parent = parent;
	}

	@Override
	public ICloudRepository getCloudRepository() {
		return parent.getCloudRepository();
	}

	@Override
	public CloudScopeScope getCloudScopeScope() {
		return parent.getCloudScopeScope();
	}

	@Override
	public LocationScope getLocationScope() {
		return parent.getLocationScope();
	}

	@Override
	public HinemosManager getHinemosManager() {
		return parent.getHinemosManager();
	}
	
	public static Node convert(com.clustercontrol.ws.xcloud.HNode source) {
		Node node = new Node();
		node.update(source);
		return node;
	}

	@Override
	public void visit(IVisitor visitor) {
		visitor.visit(this);
	}
	@Override
	public <T> T transform(ITransformer<T> transformor) {
		return transformor.transform(this);
	}

	@Override
	public String toString() {
		return "Node [toString()=" + super.toString() + "]";
	}
}
