/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.cloud;

import java.util.List;

import com.clustercontrol.ws.xcloud.CloudSpec;
import com.clustercontrol.xcloud.model.base.IElement;
import com.clustercontrol.xcloud.model.base.PropertyId;
import com.clustercontrol.xcloud.model.base.ValueObserver;

public interface ICloudPlatform extends IElement {
	public interface p {
		static final PropertyId<ValueObserver<String>> id = new PropertyId<ValueObserver<String>>("id"){};
		static final PropertyId<ValueObserver<String>> name = new PropertyId<ValueObserver<String>>("name"){};
		static final PropertyId<ValueObserver<String>> description = new PropertyId<ValueObserver<String>>("description"){};
		static final PropertyId<ValueObserver<CloudSpec>> cloudSpec = new PropertyId<ValueObserver<CloudSpec>>("cloudSpec"){};
	}
	
	String getId();
	String getName();
	String getDescription();
	CloudSpec getCloudSpec();
	
	IHinemosManager getHinemosManager();
	List<ICloudScope> getChildCloudScopes();
}
