
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>targetTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="targetType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Facility"/>
 *     &lt;enumeration value="CloudScope"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "targetType")
@XmlEnum
public enum TargetType {

    @XmlEnumValue("Facility")
    FACILITY("Facility"),
    @XmlEnumValue("CloudScope")
    CLOUD_SCOPE("CloudScope");
    private final String value;

    TargetType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TargetType fromValue(String v) {
        for (TargetType c: TargetType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
