
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>platformServiceStatusのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="platformServiceStatus">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="normal"/>
 *     &lt;enumeration value="warn"/>
 *     &lt;enumeration value="abnormal"/>
 *     &lt;enumeration value="unknown"/>
 *     &lt;enumeration value="exception"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "platformServiceStatus")
@XmlEnum
public enum PlatformServiceStatus {

    @XmlEnumValue("normal")
    NORMAL("normal"),
    @XmlEnumValue("warn")
    WARN("warn"),
    @XmlEnumValue("abnormal")
    ABNORMAL("abnormal"),
    @XmlEnumValue("unknown")
    UNKNOWN("unknown"),
    @XmlEnumValue("exception")
    EXCEPTION("exception");
    private final String value;

    PlatformServiceStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PlatformServiceStatus fromValue(String v) {
        for (PlatformServiceStatus c: PlatformServiceStatus.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
