package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.xcloud.aws.ui.dialogs.AttachElbDialog;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.INetwork;
import com.clustercontrol.xcloud.util.CollectionComparator;

public class ModifyElbHandler extends AbstractHandler implements CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final INetwork network = (INetwork)selection.getFirstElement();

		AttachElbDialog dialog = new AttachElbDialog(HandlerUtil.getActiveShell(event), network);
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);
	
				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}

			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgConfirmModifyNetworkSetting)) {
				
				try {
					final List<String> registered = new ArrayList<>();
					final List<String> deregistered = new ArrayList<>();
					
					CollectionComparator.compareCollection(network.getAttachedInstances(), dialog.getSelectedInstances(), new CollectionComparator.Comparator<String, Instance>() {
						public boolean match(String o1, Instance o2) {return o1.equals(o2.getId());}
						public void matched(String o1, Instance o2) {}
						public void afterO1(String o1) {deregistered.add(o1);}
						public void afterO2(Instance o2) {registered.add(o2.getId());}
					});
					
					AWSOptionEndpoint endpoint = network.getLocation().getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
					if (!deregistered.isEmpty())
						endpoint.deregisterInstancesFromLoadBalancer(network.getCloudScope().getId(), network.getLocation().getId(), network.getId(), deregistered);
					if (!registered.isEmpty())
						endpoint.registerInstancesToLoadBalancer(network.getCloudScope().getId(), network.getLocation().getId(), network.getId(), registered);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgFinishModifyNetworkSetting);
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							network.getLocation().getComputeResources().updateNetworks();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
