package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityExistsException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorTrapValueInfo;
import com.clustercontrol.monitor.run.model.MonitorInfoEntity;
import com.clustercontrol.monitor.run.model.MonitorTrapValueInfoEntity;
import com.clustercontrol.monitor.run.model.MonitorTrapValueInfoEntityPK;
import com.clustercontrol.monitor.run.util.QueryUtil;

/**
 * SNMPTRAP監視の判定情報を変更する抽象クラス<BR>
 * <p>
 * SNMPTRAP監視を行う各監視管理クラスで継承してください。
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public abstract class ModifyMonitorTrapValueType extends ModifyMonitor {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory
			.getLog(ModifyMonitorTrapValueType.class);

	@Override
	protected boolean modifyJudgementInfo() throws MonitorNotFound, EntityExistsException, InvalidRole {
		m_log.debug("modifyJudgementInfo() : start");

		ArrayList<MonitorTrapValueInfo> valueList = m_monitorInfo.getTrapValueInfo();

		// SNMPTRAP監視判定情報を設定
		if(valueList == null){
			m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() + ", MonitorTrapValueInfo List is null");
			valueList = new ArrayList<MonitorTrapValueInfo>();
		}

		// SNMPTRAP監視判定情報を設定
		MonitorInfoEntity monitorEntity = QueryUtil.getMonitorInfoPK(m_monitorInfo.getMonitorId());

		List<MonitorTrapValueInfoEntityPK> monitorTrapValueInfoEntityPkList = new ArrayList<MonitorTrapValueInfoEntityPK>();

		for(MonitorTrapValueInfo value : valueList){
			if(value != null){
				MonitorTrapValueInfoEntity entity = null;
				MonitorTrapValueInfoEntityPK entityPk = new MonitorTrapValueInfoEntityPK(
						m_monitorInfo.getMonitorId(),
						value.getMib(),
						value.getTrapOid(),
						value.getGenericId(),
						value.getSpecificId(),
						value.getUei());
				try {
					entity = QueryUtil.getMonitorTrapValueInfoPK(entityPk);
				} catch (MonitorNotFound e) {
					// 新規登録
					entity = new MonitorTrapValueInfoEntity(entityPk, monitorEntity);
				}

				entity.setDescr(value.getDescr());
				entity.setLogmsg(value.getLogmsg());
				entity.setPriority(value.getPriority());
				entity.setValidFlg(ValidConstant.booleanToType(value.isValidFlg()));
				monitorTrapValueInfoEntityPkList.add(entityPk);
				// for debug
				m_log.debug("modifyJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() +
						",Mib = " + value.getMib() +
						",TrapOid = " + value.getTrapOid() +
						",GenericId = " + value.getGenericId() +
						",SpecificId = " + value.getSpecificId() +
						",Uei = " + value.getUei() +
						",ValidFlg = " + value.isValidFlg() +
						",Priority = " + value.getPriority() +
						",Logmsg = " + value.getLogmsg() +
						",Descr = " + value.getDescr());
			}
		}
		// 不要なMonitorTrapValueInfoEntityを削除
		monitorEntity.deleteMonitorTrapValueInfoEntities(monitorTrapValueInfoEntityPkList);

		m_log.debug("modifyJudgementInfo() : end");
		return true;
	}

}
