/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;


/**
 * 一括制御情報の基底クラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class ItemInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = 8658155648192008796L;

	/** 種別 */
	private Integer type = new Integer(0);

	/** 名前 */
	private String name;

	/** 表示順序 */
	private Integer orderNo = new Integer(0);

	/**
	 * @return
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * @param type
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return
	 */
	public Integer getOrderNo() {
		return orderNo;
	}

	/**
	 * @param orderNo
	 */
	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		try {
			ItemInfo clone = (ItemInfo)super.clone();

			clone.setType(this.getType());
			clone.setName(this.getName());
			clone.setOrderNo(this.getOrderNo());

			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}