/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.jpasecurity.CascadeType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.FetchType;
import net.sf.jpasecurity.mapping.AbstractPropertyMappingInformation;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.PropertyAccessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipMappingInformation
extends AbstractPropertyMappingInformation {
    private ClassMappingInformation relatedClassMapping;
    private FetchType fetchType;
    private Set<CascadeType> cascadeTypes;

    RelationshipMappingInformation(String propertyName, ClassMappingInformation relatedClassMapping, ClassMappingInformation declaringClassMapping, PropertyAccessStrategy propertyAccessStrategy, ExceptionFactory exceptionFactory, FetchType fetchType, CascadeType ... cascadeTypes) {
        super(propertyName, declaringClassMapping, propertyAccessStrategy, exceptionFactory);
        if (relatedClassMapping == null) {
            throw exceptionFactory.createMappingException("could not determine target class for property \"" + propertyName + "\" of class " + declaringClassMapping.getEntityName());
        }
        if (fetchType == null) {
            throw new IllegalArgumentException("fetchType may not be null");
        }
        this.relatedClassMapping = relatedClassMapping;
        this.fetchType = fetchType;
        this.cascadeTypes = Collections.unmodifiableSet(new HashSet<CascadeType>(Arrays.asList(cascadeTypes)));
    }

    @Override
    public boolean isRelationshipMapping() {
        return true;
    }

    public ClassMappingInformation getRelatedClassMapping() {
        return this.relatedClassMapping;
    }

    @Override
    public Class<?> getProperyType() {
        return this.relatedClassMapping.getEntityType();
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    void setFetchType(FetchType fetchType) {
        if (fetchType == null) {
            throw new IllegalArgumentException("fetchType may not be null");
        }
        this.fetchType = fetchType;
    }

    @Override
    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    void setCascadeTypes(CascadeType ... cascadeTypes) {
        this.cascadeTypes = Collections.unmodifiableSet(new HashSet<CascadeType>(Arrays.asList(cascadeTypes)));
    }
}

