/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.BeanStore;
import net.sf.jpasecurity.CascadeType;
import net.sf.jpasecurity.LockModeType;
import net.sf.jpasecurity.Parameter;
import net.sf.jpasecurity.Parameterizable;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.entity.AbstractSecureCollection;
import net.sf.jpasecurity.entity.DefaultSecureMap;
import net.sf.jpasecurity.entity.DefaultSecureObjectLoader;
import net.sf.jpasecurity.entity.SecureList;
import net.sf.jpasecurity.entity.SecureObjectManager;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.CollectionValuedRelationshipMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;
import net.sf.jpasecurity.proxy.EntityProxy;
import net.sf.jpasecurity.util.SystemIdentity;
import net.sf.jpasecurity.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecureObjectManager
extends DefaultSecureObjectLoader
implements SecureObjectManager {
    protected final BeanStore beanStore;
    private Map<SystemIdentity, Object> secureEntities = new HashMap<SystemIdentity, Object>();
    private Map<SystemIdentity, Object> unsecureEntities = new HashMap<SystemIdentity, Object>();

    public DefaultSecureObjectManager(MappingInformation mappingInformation, BeanStore beanStore, AccessManager accessManager, Configuration configuration) {
        super(mappingInformation, beanStore, accessManager, configuration);
        this.beanStore = beanStore;
    }

    @Override
    public void persist(Object secureEntity) {
        Object unsecureEntity = this.getUnsecureObject(secureEntity);
        this.cascade(secureEntity, unsecureEntity, CascadeType.PERSIST, new HashSet<SystemIdentity>());
        this.preFlush();
        this.beanStore.persist(unsecureEntity);
        this.postFlush();
    }

    public <T> T merge(T entity) {
        boolean isNew = this.isNew(entity);
        this.preFlush();
        T unsecureEntity = this.getUnsecureObject(entity);
        if (isNew) {
            this.cascade(entity, unsecureEntity, CascadeType.MERGE, new HashSet<SystemIdentity>());
        }
        unsecureEntity = this.beanStore.merge(unsecureEntity);
        this.postFlush();
        if (!isNew) {
            this.cascade(entity, unsecureEntity, CascadeType.MERGE, new HashSet<SystemIdentity>());
        }
        T secureEntity = this.getSecureObject(unsecureEntity);
        this.initialize(secureEntity, unsecureEntity, isNew, CascadeType.MERGE, new HashSet<Object>());
        if (isNew) {
            this.unsecureEntities.put(new SystemIdentity(secureEntity), unsecureEntity);
        }
        return secureEntity;
    }

    @Override
    public boolean contains(Object entity) {
        return this.beanStore.contains(this.getUnsecureObject(entity));
    }

    @Override
    public void refresh(Object entity) {
        this.checkAccess(AccessType.READ, entity);
        Object unsecureEntity = this.getUnsecureObject(entity);
        this.preFlush();
        this.beanStore.refresh(unsecureEntity);
        this.postFlush();
        if (entity instanceof SecureEntity) {
            this.initialize((SecureEntity)entity, true);
        }
        this.cascadeRefresh(entity, unsecureEntity, new HashSet<SystemIdentity>());
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        if (lockMode == LockModeType.READ && !this.isAccessible(AccessType.READ, entity)) {
            throw new SecurityException("specified entity is not readable for locking");
        }
        if (lockMode == LockModeType.WRITE && !this.isAccessible(AccessType.UPDATE, entity)) {
            throw new SecurityException("specified entity is not updateable for locking");
        }
        this.beanStore.lock(this.getUnsecureObject(entity), lockMode);
    }

    @Override
    public void remove(Object entity) {
        this.checkAccess(AccessType.DELETE, entity);
        Object unsecureEntity = this.getUnsecureObject(entity);
        this.cascadeRemove(entity, unsecureEntity, new HashSet<SystemIdentity>());
        if (entity instanceof SecureEntity) {
            this.setRemoved((SecureEntity)entity);
        }
        this.beanStore.remove(unsecureEntity);
    }

    @Override
    public void detach(Object secureBean) {
        Object unsecureBean = this.getUnsecureObject(secureBean);
        this.unsecureEntities.remove(new SystemIdentity(secureBean));
        this.secureEntities.remove(new SystemIdentity(unsecureBean));
        this.beanStore.detach(unsecureBean);
    }

    @Override
    public <P extends Parameterizable> P setParameter(P parameterizable, int index, Object value) {
        parameterizable.setParameter(index, this.convertParameter(value));
        return parameterizable;
    }

    @Override
    public <P extends Parameterizable> P setParameter(P parameterizable, String name, Object value) {
        parameterizable.setParameter(name, this.convertParameter(value));
        return parameterizable;
    }

    @Override
    public <P extends Parameterizable, T> P setParameter(P parameterizable, Parameter<T> parameter, T value) {
        parameterizable.setParameter(parameter, this.convertParameter(value));
        return null;
    }

    private <T> T convertParameter(T value) {
        if (value == null || Types.isSimplePropertyType(value.getClass())) {
            return value;
        }
        if (value instanceof Collection) {
            ArrayList parameter = new ArrayList();
            for (Object entry : (Collection)value) {
                if (Types.isSimplePropertyType(entry.getClass())) {
                    parameter.add(entry);
                    continue;
                }
                parameter.add(this.convertParameter(entry));
            }
            return (T)parameter;
        }
        if (this.containsUnsecureObject(value)) {
            return this.getUnsecureObject(value);
        }
        ClassMappingInformation classMapping = this.getClassMapping(value.getClass());
        Object id = classMapping.getId(value);
        if (id == null) {
            return value;
        }
        Object managedValue = this.beanStore.find(classMapping.getEntityType(), id);
        return (T)(managedValue == null ? value : managedValue);
    }

    @Override
    public void preFlush() {
        Set<Map.Entry<SystemIdentity, Object>> entities = this.unsecureEntities.entrySet();
        for (Map.Entry unsecureEntity : entities.toArray(new Map.Entry[entities.size()])) {
            this.unsecureCopy(AccessType.UPDATE, ((SystemIdentity)unsecureEntity.getKey()).getObject(), unsecureEntity.getValue());
        }
    }

    @Override
    public void postFlush() {
        for (Map.Entry<SystemIdentity, Object> secureEntity : this.secureEntities.entrySet()) {
            this.copyIdAndVersion(secureEntity.getKey().getObject(), secureEntity.getValue());
        }
        super.postFlush();
    }

    @Override
    public void clear() {
        this.secureEntities.clear();
        this.unsecureEntities.clear();
    }

    @Override
    public boolean isSecureObject(Object object) {
        if (super.isSecureObject(object)) {
            return true;
        }
        if (object instanceof EntityProxy) {
            object = ((EntityProxy)object).getEntity();
        }
        return this.unsecureEntities.containsKey(new SystemIdentity(object));
    }

    @Override
    public <E> Collection<E> getSecureObjects(Class<E> type) {
        ArrayList<E> result = new ArrayList<E>();
        for (Object secureEntity : this.secureEntities.values()) {
            if (!type.isInstance(secureEntity)) continue;
            result.add(type.cast(secureEntity));
        }
        return Collections.unmodifiableCollection(result);
    }

    public <T> T getReference(Class<T> type, Object id) {
        return this.getSecureObject(this.beanStore.getReference(type, id));
    }

    @Override
    public <T> T getSecureObject(T unsecureObject) {
        if (unsecureObject == null) {
            return null;
        }
        Object secureEntity = this.secureEntities.get(new SystemIdentity(unsecureObject));
        if (secureEntity != null) {
            return (T)secureEntity;
        }
        return super.getSecureObject(unsecureObject);
    }

    @Override
    boolean containsUnsecureObject(Object secureObject) {
        if (secureObject == null) {
            return true;
        }
        if (secureObject instanceof EntityProxy) {
            secureObject = ((EntityProxy)secureObject).getEntity();
        }
        if (this.unsecureEntities.containsKey(new SystemIdentity(secureObject))) {
            return true;
        }
        return super.containsUnsecureObject(secureObject);
    }

    @Override
    <T> T getUnsecureObject(T secureObject) {
        Object unsecureEntity;
        if (secureObject == null) {
            return null;
        }
        if (secureObject instanceof EntityProxy) {
            secureObject = ((EntityProxy)secureObject).getEntity();
        }
        if ((unsecureEntity = this.unsecureEntities.get(new SystemIdentity(secureObject))) != null) {
            return (T)unsecureEntity;
        }
        return super.getUnsecureObject(secureObject);
    }

    @Override
    <T> T createUnsecureObject(T secureEntity) {
        if (secureEntity instanceof EntityProxy) {
            secureEntity = ((EntityProxy)secureEntity).getEntity();
        }
        AccessType accessType = this.isNew(secureEntity) ? AccessType.CREATE : AccessType.UPDATE;
        ClassMappingInformation classMapping = this.getClassMapping(secureEntity.getClass());
        this.checkAccess(accessType, secureEntity);
        Object unsecureEntity = classMapping.newInstance();
        this.secureEntities.put(new SystemIdentity(unsecureEntity), secureEntity);
        this.unsecureEntities.put(new SystemIdentity(secureEntity), unsecureEntity);
        this.unsecureCopy(accessType, secureEntity, unsecureEntity);
        return (T)unsecureEntity;
    }

    boolean isNew(Object entity) {
        if (entity instanceof SecureEntity) {
            return false;
        }
        ClassMappingInformation classMapping = this.getClassMapping(entity.getClass());
        Object id = classMapping.getId(entity);
        if (id == null) {
            return true;
        }
        return this.beanStore.find(classMapping.getEntityType(), id) == null;
    }

    void cascade(Object secureEntity, Object unsecureEntity, CascadeType cascadeType, Set<SystemIdentity> alreadyCascadedEntities) {
        if (cascadeType == CascadeType.REMOVE) {
            this.cascadeRemove(secureEntity, unsecureEntity, alreadyCascadedEntities);
            return;
        }
        if (secureEntity == null || alreadyCascadedEntities.contains(new SystemIdentity(secureEntity))) {
            return;
        }
        alreadyCascadedEntities.add(new SystemIdentity(secureEntity));
        AccessType accessType = this.isNew(secureEntity) ? AccessType.CREATE : AccessType.UPDATE;
        this.unsecureCopy(accessType, secureEntity, unsecureEntity);
        ClassMappingInformation classMapping = this.getClassMapping(secureEntity.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object unsecureEntry;
            Object secureValue;
            if (!propertyMapping.isRelationshipMapping() || !propertyMapping.getCascadeTypes().contains((Object)cascadeType) && !propertyMapping.getCascadeTypes().contains((Object)CascadeType.ALL) || (secureValue = propertyMapping.getPropertyValue(secureEntity)) == null) continue;
            if (propertyMapping.isSingleValued()) {
                this.cascade(secureValue, this.getUnsecureObject(secureValue), cascadeType, alreadyCascadedEntities);
                continue;
            }
            CollectionValuedRelationshipMappingInformation collectionMapping = (CollectionValuedRelationshipMappingInformation)propertyMapping;
            if (Collection.class.isAssignableFrom(collectionMapping.getCollectionType())) {
                for (Object secureEntry : (Collection)secureValue) {
                    unsecureEntry = this.getUnsecureObject(secureEntry);
                    this.cascade(secureEntry, unsecureEntry, cascadeType, alreadyCascadedEntities);
                }
                continue;
            }
            if (!Map.class.isAssignableFrom(collectionMapping.getCollectionType())) continue;
            for (Object secureEntry : ((Map)secureValue).values()) {
                unsecureEntry = this.getUnsecureObject(secureEntry);
                this.cascade(secureEntry, unsecureEntry, cascadeType, alreadyCascadedEntities);
            }
        }
    }

    private void cascadeRemove(Object secureEntity, Object unsecureEntity, Set<SystemIdentity> alreadyCascadedEntities) {
        if (secureEntity == null || alreadyCascadedEntities.contains(new SystemIdentity(secureEntity))) {
            return;
        }
        alreadyCascadedEntities.add(new SystemIdentity(secureEntity));
        this.checkAccess(AccessType.DELETE, secureEntity);
        ClassMappingInformation classMapping = this.getClassMapping(secureEntity.getClass());
        this.fireRemove(classMapping, secureEntity);
        this.secureEntities.remove(new SystemIdentity(unsecureEntity));
        this.unsecureEntities.remove(new SystemIdentity(secureEntity));
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object secureValue;
            if (!propertyMapping.isRelationshipMapping() || !propertyMapping.getCascadeTypes().contains((Object)CascadeType.REMOVE) && !propertyMapping.getCascadeTypes().contains((Object)CascadeType.ALL) || (secureValue = propertyMapping.getPropertyValue(secureEntity)) == null) continue;
            if (propertyMapping.isSingleValued()) {
                this.cascadeRemove(secureValue, this.getUnsecureObject(secureValue), alreadyCascadedEntities);
                if (!(secureValue instanceof SecureEntity)) continue;
                this.setRemoved((SecureEntity)secureValue);
                continue;
            }
            Object unsecureValue = propertyMapping.getPropertyValue(unsecureEntity);
            if (unsecureValue instanceof Collection) {
                Collection unsecureCollection = (Collection)unsecureValue;
                for (Object unsecureEntry : unsecureCollection) {
                    this.cascadeRemove(this.getSecureObject((T)unsecureEntry), unsecureEntry, alreadyCascadedEntities);
                }
                continue;
            }
            if (unsecureValue instanceof Map) {
                Map unsecureMap = (Map)unsecureValue;
                for (Object unsecureEntry : unsecureMap.values()) {
                    this.cascadeRemove(this.getSecureObject((T)unsecureEntry), unsecureEntry, alreadyCascadedEntities);
                }
                continue;
            }
            throw new IllegalStateException("unsupported type " + unsecureValue.getClass().getName());
        }
    }

    private void cascadeRefresh(Object secureEntity, Object unsecureEntity, Set<SystemIdentity> alreadyCascadedEntities) {
        if (secureEntity == null || alreadyCascadedEntities.contains(new SystemIdentity(secureEntity))) {
            return;
        }
        alreadyCascadedEntities.add(new SystemIdentity(secureEntity));
        ClassMappingInformation classMapping = this.getClassMapping(secureEntity.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object secureValue;
            if (!propertyMapping.isRelationshipMapping() || !propertyMapping.getCascadeTypes().contains((Object)CascadeType.REFRESH) && !propertyMapping.getCascadeTypes().contains((Object)CascadeType.ALL) || (secureValue = propertyMapping.getPropertyValue(secureEntity)) == null) continue;
            if (propertyMapping.isSingleValued()) {
                Object unsecureValue = this.getUnsecureObject(secureValue);
                if (secureValue instanceof SecureEntity) {
                    this.initialize((SecureEntity)secureValue, true);
                } else {
                    this.secureCopy(unsecureValue, secureValue);
                }
                this.cascadeRefresh(secureValue, unsecureValue, alreadyCascadedEntities);
                continue;
            }
            Collection unsecureCollection = (Collection)propertyMapping.getPropertyValue(unsecureEntity);
            for (Object unsecureEntry : unsecureCollection) {
                this.cascadeRemove(this.getSecureObject((T)unsecureEntry), unsecureEntry, alreadyCascadedEntities);
            }
        }
    }

    private void initialize(Object secureEntity, Object unsecureEntity, boolean isNew, CascadeType cascadeType, Set<Object> alreadyInitializedEntities) {
        if (alreadyInitializedEntities.contains(secureEntity)) {
            return;
        }
        if (secureEntity instanceof SecureEntity && !((SecureEntity)secureEntity).isInitialized()) {
            this.initialize((SecureEntity)secureEntity, !isNew);
        }
        alreadyInitializedEntities.add(secureEntity);
        ClassMappingInformation classMapping = this.getClassMapping(secureEntity.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object secureValue;
            if (!propertyMapping.isRelationshipMapping() || !propertyMapping.getCascadeTypes().contains((Object)cascadeType) && !propertyMapping.getCascadeTypes().contains((Object)CascadeType.ALL) || (secureValue = propertyMapping.getPropertyValue(secureEntity)) == null) continue;
            if (propertyMapping.isSingleValued()) {
                this.initialize(secureValue, this.getUnsecureObject(secureValue), this.isNew(secureValue), cascadeType, alreadyInitializedEntities);
                continue;
            }
            if (secureValue instanceof AbstractSecureCollection) {
                AbstractSecureCollection secureCollection = (AbstractSecureCollection)secureValue;
                secureCollection.initialize(!isNew);
            } else if (secureValue instanceof SecureList) {
                SecureList secureList = (SecureList)secureValue;
                secureList.initialize(!isNew);
            } else if (secureValue instanceof DefaultSecureMap) {
                DefaultSecureMap secureMap = (DefaultSecureMap)secureValue;
                secureMap.initialize(!isNew);
            }
            if (secureValue instanceof Collection) {
                for (Object secureEntry : (Collection)secureValue) {
                    this.initialize(secureEntry, this.getUnsecureObject(secureEntry), this.isNew(secureEntity), cascadeType, alreadyInitializedEntities);
                }
                continue;
            }
            if (secureValue instanceof Map) {
                for (Object secureEntry : ((Map)secureValue).values()) {
                    this.initialize(secureEntry, this.getUnsecureObject(secureEntry), this.isNew(secureEntity), cascadeType, alreadyInitializedEntities);
                }
                continue;
            }
            throw new IllegalStateException("unsupported type " + secureValue.getClass().getName());
        }
    }
}

