/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.BeanStore;
import net.sf.jpasecurity.SecureCollection;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.SecureMap;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.entity.DefaultSecureObjectManager;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.util.SystemIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecureObjectCache
extends DefaultSecureObjectManager {
    private Map<ClassMappingInformation, Map<Object, SecureEntity>> secureEntities = new HashMap<ClassMappingInformation, Map<Object, SecureEntity>>();
    private Map<SystemIdentity, SecureCollection<?>> secureCollections = new HashMap();
    private Map<SystemIdentity, SecureMap<?, ?>> secureMaps = new HashMap();

    public DefaultSecureObjectCache(MappingInformation mappingInformation, BeanStore beanStore, AccessManager accessManager, Configuration configuration) {
        super(mappingInformation, beanStore, accessManager, configuration);
    }

    public SecureCollection<?> getSecureCollection(Collection<?> unsecureCollection) {
        SecureCollection secureCollection = this.secureCollections.get(new SystemIdentity(unsecureCollection));
        if (secureCollection != null) {
            return secureCollection;
        }
        secureCollection = (SecureCollection)super.getSecureObject(unsecureCollection);
        this.secureCollections.put(new SystemIdentity(unsecureCollection), secureCollection);
        return secureCollection;
    }

    public SecureMap<?, ?> getSecureMap(Map<?, ?> unsecureMap) {
        SecureMap secureMap = this.secureMaps.get(new SystemIdentity(unsecureMap));
        if (secureMap != null) {
            return secureMap;
        }
        secureMap = (SecureMap)super.getSecureObject(unsecureMap);
        this.secureMaps.put(new SystemIdentity(unsecureMap), secureMap);
        return secureMap;
    }

    public <E> E getReference(Class<E> type, Object id) {
        return this.getSecureEntity(this.beanStore.getReference(type, id), id);
    }

    @Override
    public void detach(Object secureBean) {
        ClassMappingInformation classMapping;
        Map<Object, SecureEntity> entities;
        if (secureBean instanceof SecureEntity && (entities = this.secureEntities.get(classMapping = this.getClassMapping(secureBean.getClass()))) != null) {
            Object id = this.getIdentifier(secureBean);
            entities.remove(id);
        }
        super.detach(secureBean);
    }

    @Override
    public <E> E getSecureObject(E unsecureObject) {
        if (unsecureObject == null) {
            return null;
        }
        if (unsecureObject instanceof Collection) {
            return (E)this.getSecureCollection((Collection)unsecureObject);
        }
        if (unsecureObject instanceof Map) {
            return (E)this.getSecureMap((Map)unsecureObject);
        }
        ClassMappingInformation classMapping = this.getClassMapping(unsecureObject.getClass());
        Object id = classMapping.getId(unsecureObject);
        return this.getSecureEntity(unsecureObject, id);
    }

    @Override
    public <E> Collection<E> getSecureObjects(Class<E> type) {
        ArrayList<SecureEntity> secureObjects = new ArrayList<SecureEntity>();
        for (Map.Entry<ClassMappingInformation, Map<Object, SecureEntity>> entities : this.secureEntities.entrySet()) {
            if (!entities.getKey().getEntityType().isAssignableFrom(type)) continue;
            secureObjects.addAll(entities.getValue().values());
        }
        secureObjects.addAll(super.getSecureObjects(type));
        return secureObjects;
    }

    @Override
    public void preFlush() {
        super.preFlush();
        for (Map entities : this.secureEntities.values().toArray(new Map[this.secureEntities.size()])) {
            for (SecureEntity entity : entities.values().toArray(new SecureEntity[entities.size()])) {
                if (!entity.isInitialized()) continue;
                entity.flush();
            }
        }
    }

    @Override
    public void postFlush() {
        for (Map entities : this.secureEntities.values().toArray(new Map[this.secureEntities.size()])) {
            for (SecureEntity entity : entities.values().toArray(new SecureEntity[entities.size()])) {
                SecureEntity unsecureObject = this.getUnsecureObject(entity);
                this.copyIdAndVersion(unsecureObject, entity);
            }
        }
        super.postFlush();
    }

    @Override
    public void clear() {
        super.clear();
        this.secureEntities.clear();
        this.secureCollections.clear();
        this.secureMaps.clear();
    }

    private <E> E getSecureEntity(E unsecureObject, Object id) {
        SecureEntity entity;
        ClassMappingInformation classMapping = this.getClassMapping(unsecureObject.getClass());
        Map<Object, SecureEntity> entities = this.secureEntities.get(classMapping);
        if (entities == null) {
            entities = new HashMap<Object, SecureEntity>();
            this.secureEntities.put(classMapping, entities);
        }
        if ((entity = entities.get(id)) != null) {
            return (E)entity;
        }
        E secureObject = super.getSecureObject(unsecureObject);
        if (secureObject instanceof SecureEntity && id != null) {
            entities.put(id, (SecureEntity)secureObject);
        }
        return secureObject;
    }
}

