/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.agent.util;

import java.util.HashMap;
import java.util.Map;

import com.clustercontrol.ws.monitor.CommandExecuteDTO;
import com.clustercontrol.ws.monitor.CommandResultDTO;
import com.clustercontrol.ws.monitor.CommandResultDTO.InvalidLines;
import com.clustercontrol.ws.monitor.CommandResultDTO.Results;
import com.clustercontrol.ws.monitor.CommandVariableDTO;
import com.clustercontrol.ws.monitor.CommandVariableDTO.Variables.Entry;

/**
 * Utilities for Command Monitoring WS DTO
 * @author takahatat
 *
 */
public class CommandMonitoringWSUtil {

	public static Map<String, String> getVariable(CommandExecuteDTO dto, String facilityId) {
		// Local Variable
		CommandVariableDTO variableDTO = null;
		Map<String, String> ret = new HashMap<String, String>();

		// Main
		variableDTO = getVariableDTO(dto, facilityId);
		if (variableDTO != null && variableDTO.getVariables() != null && variableDTO.getVariables().getEntry() != null) {
			for (CommandVariableDTO.Variables.Entry entry : variableDTO.getVariables().getEntry()) {
				ret.put(entry.getKey(), entry.getValue());
			}
		}

		return ret;
	}

	public static CommandVariableDTO getVariableDTO(CommandExecuteDTO dto, String facilityId) {
		// Local Variable
		CommandVariableDTO ret = null;

		// Main
		if (dto.getVariables() != null) {
			for (CommandVariableDTO vdto : dto.getVariables()) {
				if (facilityId.equals(vdto.getFacilityId())) {
					ret = vdto;
					break;
				}
			}
		}

		return ret;
	}

	public static String toStringCommandExecuteDTO(CommandExecuteDTO dto) {
		// Local Variables
		String ret = null;
		String variablesStr = null;

		// MAIN
		if (dto != null) {
			if (dto.getVariables() != null) {
				for (CommandVariableDTO vdto : dto.getVariables()) {
					if (variablesStr == null) {
						variablesStr = vdto.getFacilityId();
					} else {
						variablesStr += ", " + vdto.getFacilityId();
					}
				}
			}

			ret = "CommandConfig [monitorId = " + dto.getMonitorId()
					+ ", effectiveUser = " + dto.getEffectiveUser()
					+ ", command = " + dto.getCommand()
					+ ", timeout = " + dto.getTimeout()
					+ ", interval = " + dto.getInterval()
					+ ", calendar = " + (dto.getCalendar() == null ? null : dto.getCalendar().getId())
					+ ", variables = (" + variablesStr + ")"
					+ "]";
		}

		return ret;
	}

	public static String toStringCommandVariableDTO(CommandVariableDTO dto) {
		// Local Variables
		String ret = null;
		String variableStr = null;

		// MAIN
		if (dto != null) {
			if (dto.getVariables() != null && dto.getVariables().getEntry() != null) {
				for (Entry entry : dto.getVariables().getEntry()) {
					variableStr += variableStr == null ? "" : ", ";
					variableStr += "[key = " + entry.getKey() + ", value = " + entry.getValue() + "]";
				}
			}

			ret = "CommandVariableDTO [facilityId = " + dto.getFacilityId()
					+ "variables = (" + variableStr + ")"
					+ "]";
		}

		return ret;
	}

	public static String toStringCommandResultDTO(CommandResultDTO dto) {
		// Local Variables
		String ret = null;

		// MAIN
		if (dto != null) {
			ret = "CommandResultDTO [monitorId = " + dto.getMonitorId()
					+ ", facilityId = " + dto.getFacilityId()
					+ ", command = " + dto.getCommand()
					+ ", user = " + dto.getUser()
					+ ", timeout = " + dto.isTimeout()
					+ ", exitCode = " + dto.getExitCode()
					+ ", stdout = " + dto.getStdout()
					+ ", stderr = " + dto.getStderr()
					+ ", collectDate = " + dto.getCollectDate()
					+ ", executeDate = " + dto.getExecuteDate()
					+ ", exitDate = " + dto.getExitDate()
					+ ", results = (" + toStringResults(dto.getResults()) + ")"
					+ ", invalieLines = (" + toStringInvalidLines(dto.getInvalidLines()) + ")"
					+ "]";

		}

		return ret;
	}

	public static String toStringResults(Results dto) {
		// Local Variables
		String ret = null;

		// MAIN
		if (dto != null && dto.getEntry() != null) {
			ret = "";
			for (CommandResultDTO.Results.Entry entry : dto.getEntry()) {
				ret += "[key = " + entry.getKey()
						+ ", value = " + entry.getValue()
						+ "]";
			}
		}

		return ret;
	}

	public static String toStringInvalidLines(InvalidLines dto) {
		// Local Variables
		String ret = null;

		// MAIN
		if (dto != null && dto.getEntry() != null) {
			ret = "";
			for (CommandResultDTO.InvalidLines.Entry entry : dto.getEntry()) {
				ret += "[key = " + entry.getKey()
						+ ", value = " + entry.getValue()
						+ "]";
			}
		}

		return ret;
	}

}
