/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.persistence.EntityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.model.SnmpTrapMibMstEntity;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 * MIBマスター情報を削除するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class DeleteMibMaster {

	private static Log m_log = LogFactory.getLog( DeleteMibMaster.class );


	private String m_Mib;

	/**
	 * MIB情報を削除します。
	 * 
	 * @param MibData　削除するMIBマスター
	 * @param user　　　削除実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean delete(String  mib) throws MonitorNotFound {

		m_Mib = mib;

		boolean result = false;
		// 監視情報を登録
		result = deleteMibMaster();

		return result;
	}

	/**
	 * MIBマスターの削除を行う。
	 * @param user　削除実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean deleteMibMaster() throws MonitorNotFound {
		boolean result = false;
		EntityManager em = new JpaTransactionManager().getEntityManager();

		// 監視情報を検索
		SnmpTrapMibMstEntity entity = QueryUtil.getSnmpTrapMibMstPK(m_Mib);
		em.remove(entity);

		result = true;
		return result;
	}
}
