/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.persistence.EntityExistsException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntity;

/**
 *OIDマスター情報を登録するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class AddOidMaster {

	private static Log m_log = LogFactory.getLog( AddOidMaster.class );

	/** 監視情報ビーン */
	private SnmpTrapMasterInfo m_OidData;

	/**
	 * OIDマスター情報を登録します。
	 * @param oidData  登録するOIDマスター
	 * @param user     登録実行ユーザ
	 * @return
	 * @throws EntityExistsException
	 */
	public boolean add(SnmpTrapMasterInfo oidData, String user) throws EntityExistsException {

		m_OidData = oidData;

		boolean result = false;

		// 監視情報を登録
		result = addOIDMaster(user);

		return result;
	}

	/**
	 *  OIDマスター情報を登録します。<BR>
	 * 
	 * @param user ユーザ
	 * @return 登録に成功した場合、true
	 * @throws EntityExistsException
	 */
	public boolean addOIDMaster(String user) throws EntityExistsException {
		boolean result = false;
		JpaTransactionManager jtm = new JpaTransactionManager();

		try
		{
			// インスタンス生成
			SnmpTrapMstEntity entity = new SnmpTrapMstEntity(
					m_OidData.getMib(),
					m_OidData.getTrapOid(),
					m_OidData.getGenericId(),
					m_OidData.getSpecificId(),
					null);
			// 重複チェック
			jtm.checkEntityExists(SnmpTrapMstEntity.class, entity.getId());
			entity.setDescr(m_OidData.getDescr());
			entity.setLogmsg(m_OidData.getLogmsg());
			entity.setPriority(m_OidData.getPriority());
			entity.setUei(m_OidData.getUei());

			result = true;

		} catch (EntityExistsException e) {
			m_log.info("addOIDMaster() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return result;
	}
}
