/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * SNMPTRAP監視のTRAPマスター情報Bean(DTO)クラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://monitor.ws.clustercontrol.com")
public class SnmpTrapMasterInfo implements Serializable{
	private static final long serialVersionUID = 5737352544693128254L;

	private String mib;
	private String trapOid;
	private Integer genericId = new Integer(0);
	private Integer specificId = new Integer(0);
	private String uei;
	private Integer priority = new Integer(0);
	private String logmsg;
	private String descr;

	public SnmpTrapMasterInfo(){

	}
	/**
	 * 説明を取得します。<BR>
	 * @return 説明
	 */
	public String getDescr() {
		return descr;
	}
	/**
	 * 説明を設定します。<BR>
	 * @param descr
	 */
	public void setDescr(String descr) {
		this.descr = descr;
	}
	/**
	 * GenericIdを取得します。<BR>
	 * @return geniricId
	 */
	public Integer getGenericId() {
		return genericId;
	}
	/**
	 * GenericIdを設定します。<BR>
	 * @param genericId
	 */
	public void setGenericId(Integer genericId) {
		this.genericId = genericId;
	}
	/**
	 * ログメッセージを取得します。<BR>
	 * @return ログメッセージ
	 */
	public String getLogmsg() {
		return logmsg;
	}
	/**
	 * ログメッセージを設定します。<BR>
	 * @param logmsg
	 */
	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}
	/**
	 * MIBを取得します。<BR>
	 * @return
	 */
	public String getMib() {
		return mib;
	}
	/**
	 * MIBを設定します。<BR>
	 * @param mib
	 */
	public void setMib(String mib) {
		this.mib = mib;
	}
	/**
	 * SpecificIdを取得します。<BR>
	 * @return
	 */
	public Integer getSpecificId() {
		return specificId;
	}
	/**
	 * SepecificIdを設定します。<BR>
	 * @param specificId
	 */
	public void setSpecificId(Integer specificId) {
		this.specificId = specificId;
	}
	/**
	 * トラップOID名を取得します。<BR>
	 * @return トラップOID名
	 */
	public String getTrapOid() {
		return trapOid;
	}
	/**
	 * トラップOID名を設定します。<BR>
	 * @param trapOid
	 */
	public void setTrapOid(String trapOid) {
		this.trapOid = trapOid;
	}
	/**
	 * UEIを取得します。
	 * @return　uei
	 */
	//FIXME ueiってなに？
	public String getUei() {
		return uei;
	}
	/**
	 * UEIを設定します。<BR>
	 * @param uei
	 */
	public void setUei(String uei) {
		this.uei = uei;
	}
	/**
	 * OIDの重要度を取得します。<BR>
	 * @return OIDの重要度
	 */
	public Integer getPriority() {
		return priority;
	}
	/**
	 * OIDの重要度を設定します。<BR>
	 * @param priority
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
}
