/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.util;

import java.sql.Timestamp;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.model.CrunCmdMstEntity;
import com.clustercontrol.collectiverun.model.CrunCmdParamMstEntity;
import com.clustercontrol.collectiverun.model.CrunCmdParamMstEntityPK;
import com.clustercontrol.collectiverun.model.CrunEndMstEntity;
import com.clustercontrol.collectiverun.model.CrunEndMstEntityPK;
import com.clustercontrol.collectiverun.model.CrunParamMstEntity;
import com.clustercontrol.collectiverun.model.CrunParamSelectMstEntity;
import com.clustercontrol.collectiverun.model.CrunParamSelectMstEntityPK;
import com.clustercontrol.collectiverun.model.CrunSessionDetailEntity;
import com.clustercontrol.collectiverun.model.CrunSessionDetailEntityPK;
import com.clustercontrol.collectiverun.model.CrunSessionEntity;
import com.clustercontrol.collectiverun.model.CrunSessionParamEntity;
import com.clustercontrol.collectiverun.model.CrunSessionParamEntityPK;
import com.clustercontrol.collectiverun.model.CrunTypeMstEntity;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.CollectiveRunNotFound;

public class QueryUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( QueryUtil.class );

	public static CrunTypeMstEntity getCrunTypeMstPK(String typeId) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunTypeMstEntity entity = em.find(CrunTypeMstEntity.class, typeId);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunTypeMstEntity.findByPrimaryKey, "
					+ "typeId = " + typeId);
			m_log.info("getCrunTypeMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<CrunTypeMstEntity> getAllCrunTypeMst() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunTypeMstEntity> list
		= em.createNamedQuery("CrunTypeMstEntity.findAll", CrunTypeMstEntity.class).getResultList();
		return list;
	}

	public static List<CrunTypeMstEntity> getAllCrunTypeMstSortOrderNo() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunTypeMstEntity> list
		= em.createNamedQuery("CrunTypeMstEntity.findAllSortOrderNo", CrunTypeMstEntity.class).getResultList();
		return list;
	}

	public static CrunCmdMstEntity getCrunCmdMstPK(String commandId) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunCmdMstEntity entity = em.find(CrunCmdMstEntity.class, commandId);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunCmdMstEntity.findByPrimaryKey, "
					+ "commandId = " + commandId);
			m_log.info("getCrunCmdMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<CrunCmdMstEntity> getCrunCmdMstByTypeId(String typeId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunCmdMstEntity> list
		= em.createNamedQuery("CrunCmdMstEntity.findByTypeId", CrunCmdMstEntity.class)
		.setParameter("typeId", typeId)
		.getResultList();
		return list;
	}

	public static CrunParamMstEntity getCrunParamMstPK(String paramId) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunParamMstEntity entity = em.find(CrunParamMstEntity.class, paramId);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunParamMstEntity.findByPrimaryKey, "
					+ "paramId = " + paramId);
			m_log.info("getCrunParamMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<CrunParamMstEntity> getAllCrunParamMst() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunParamMstEntity> list
		= em.createNamedQuery("CrunParamMstEntity.findAll", CrunParamMstEntity.class).getResultList();
		return list;
	}

	public static CrunCmdParamMstEntity getCrunCmdParamMstPK(CrunCmdParamMstEntityPK pk) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunCmdParamMstEntity entity = em.find(CrunCmdParamMstEntity.class, pk);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunCmdParamMstEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getCrunCmdParamMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static CrunCmdParamMstEntity getCrunCmdParamMstPK(String commandId, String paramId) throws CollectiveRunNotFound {
		return getCrunCmdParamMstPK(new CrunCmdParamMstEntityPK(commandId, paramId));
	}

	public static List<CrunCmdParamMstEntity> getCrunCmdParamMstByCommandId(String commandId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunCmdParamMstEntity> list
		= em.createNamedQuery("CrunCmdParamMstEntity.findByCommandId", CrunCmdParamMstEntity.class)
		.setParameter("commandId", commandId)
		.getResultList();
		return list;
	}

	public static CrunParamSelectMstEntity getCrunParamSelectMstPK(CrunParamSelectMstEntityPK pk) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunParamSelectMstEntity entity = em.find(CrunParamSelectMstEntity.class, pk);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunParamSelectMstEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getCrunParamSelectMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static CrunParamSelectMstEntity getCrunParamSelectMstPK(String paramId, Integer orderNo) throws CollectiveRunNotFound {
		return getCrunParamSelectMstPK(new CrunParamSelectMstEntityPK(paramId, orderNo));
	}

	public static List<CrunParamSelectMstEntity> getCrunParamSelectMstByParamId(String paramId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunParamSelectMstEntity> list
		= em.createNamedQuery("CrunParamSelectMstEntity.findByParamId", CrunParamSelectMstEntity.class)
		.setParameter("paramId", paramId)
		.getResultList();
		return list;
	}

	public static CrunEndMstEntity getCrunEndMstPK(CrunEndMstEntityPK pk) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunEndMstEntity entity = em.find(CrunEndMstEntity.class, pk);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunEndMstEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getCrunEndMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static CrunEndMstEntity getCrunEndMstPK(String commandId, Integer endStatus) throws CollectiveRunNotFound {
		return getCrunEndMstPK(new CrunEndMstEntityPK(commandId, endStatus));
	}

	public static CrunSessionEntity getCrunSessionPK(String sessionId) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunSessionEntity entity = em.find(CrunSessionEntity.class, sessionId);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunSessionEntity.findByPrimaryKey, "
					+ "sessionId = " + sessionId);
			m_log.info("getCrunSessionPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<CrunSessionEntity> getCrunSessionByStatus(int status) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunSessionEntity> list
		= em.createNamedQuery("CrunSessionEntity.findByStatus", CrunSessionEntity.class)
		.setParameter("status", status)
		.getResultList();
		return list;
	}

	public static List<CrunSessionEntity> getCrunSessionByFaciiltyId(String facilityId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunSessionEntity> list
		= em.createNamedQuery("CrunSessionEntity.findByFacilityId", CrunSessionEntity.class)
		.setParameter("facilityId", facilityId)
		.getResultList();
		return list;
	}

	public static List<CrunSessionEntity> getCrunSessionByHistoryFilter(
			Long startFromDate,
			Long startToDate,
			Long endFromDate,
			Long endToDate,
			String typeId,
			Integer status,
			Integer limit) {

		EntityManager em = new JpaTransactionManager().getEntityManager();

		// SQL作成
		StringBuffer sbJpql = new StringBuffer();
		sbJpql.append("SELECT a FROM CrunSessionEntity a WHERE true = true");
		if (startFromDate != null) {
			sbJpql.append(" AND a.startDate >= :startFromDate");
		}
		if (startToDate != null){
			sbJpql.append(" AND a.startDate <= :startToDate");
		}
		if (endFromDate != null) {
			sbJpql.append(" AND a.endDate >= :endFromDate");
		}
		if (endToDate != null){
			sbJpql.append(" AND a.endDate <= :endToDate");
		}
		if (typeId != null && typeId.length() > 0){
			sbJpql.append(" AND a.typeId = :typeId");
		}
		if (status != null && status.intValue() != -1){
			sbJpql.append(" AND a.status = :status");
		}
		sbJpql.append(" ORDER BY a.sessionId DESC");

		TypedQuery<CrunSessionEntity> typedQuery = em.createQuery(sbJpql.toString(), CrunSessionEntity.class);
		if (startFromDate != null) {
			typedQuery = typedQuery.setParameter("startFromDate", new Timestamp(startFromDate));
		}
		if (startToDate != null){
			typedQuery = typedQuery.setParameter("startToDate", new Timestamp(startToDate));
		}
		if (endFromDate != null) {
			typedQuery = typedQuery.setParameter("endFromDate", new Timestamp(endFromDate));
		}
		if (endToDate != null){
			typedQuery = typedQuery.setParameter("endToDate", new Timestamp(endToDate));
		}
		if (typeId != null && typeId.length() > 0){
			typedQuery = typedQuery.setParameter("typeId", typeId);
		}
		if (status != null && status.intValue() != -1){
			typedQuery = typedQuery.setParameter("status", status);
		}
		if (limit != null) {
			typedQuery = typedQuery.setMaxResults(limit);
		}

		List<CrunSessionEntity> sessionList = typedQuery.getResultList();
		return sessionList;
	}

	public static CrunSessionParamEntity getCrunSessionParamPK(CrunSessionParamEntityPK pk) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunSessionParamEntity entity = em.find(CrunSessionParamEntity.class, pk);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunSessionParamEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getCrunSessionParamPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static CrunSessionParamEntity getCrunSessionParamPK(String sessionId, String paramId) throws CollectiveRunNotFound {
		return getCrunSessionParamPK(new CrunSessionParamEntityPK(sessionId, paramId));
	}

	public static CrunSessionDetailEntity getCrunSessionDetailPK(CrunSessionDetailEntityPK pk) throws CollectiveRunNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		CrunSessionDetailEntity entity = em.find(CrunSessionDetailEntity.class, pk);
		if (entity == null) {
			CollectiveRunNotFound e = new CollectiveRunNotFound("CrunSessionDetailEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getCrunSessionDetailPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static CrunSessionDetailEntity getCrunSessionDetailPK(String sessionId, String facilityId) throws CollectiveRunNotFound {
		return getCrunSessionDetailPK(new CrunSessionDetailEntityPK(sessionId, facilityId));
	}

	public static List<CrunSessionDetailEntity> getCrunSessionDetailBySessionId(String sessionId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunSessionDetailEntity> list
		= em.createNamedQuery("CrunSessionDetailEntity.findBySessionId", CrunSessionDetailEntity.class)
		.setParameter("sessionId", sessionId)
		.getResultList();
		return list;
	}

	public static List<CrunSessionDetailEntity> getCrunSessionDetailByFacilityId(String facilityId) {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<CrunSessionDetailEntity> list
		= em.createNamedQuery("CrunSessionDetailEntity.findByFacilityId", CrunSessionDetailEntity.class)
		.setParameter("facilityId", facilityId)
		.getResultList();
		return list;
	}
}
